/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class NumericToBinary
extends PotentialClassIgnorer
implements UnsupervisedFilter,
StreamableFilter,
WeightedInstancesHandler,
WeightedAttributesHandler {
    protected Range m_Cols = new Range("first-last");
    protected String m_DefaultCols = "first-last";
    static final long serialVersionUID = 2616879323359470802L;

    public String globalInfo() {
        return "Converts all numeric attributes into binary attributes (apart from the class attribute, if set): if the value of the numeric attribute is exactly zero, the value of the new attribute will be zero. If the value of the numeric attribute is missing, the value of the new attribute will be missing. Otherwise, the value of the new attribute will be one. The new attributes will be nominal.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(2);
        result.addElement(new Option("\tSpecifies list of columns to binarize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setInvertSelection(Utils.getFlag('V', options));
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be 'binarized'; if true, only non-selected attributes will be 'binarized'.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    private void setOutputFormat() {
        this.m_Cols.setUpper(this.getInputFormat().numAttributes() - 1);
        int newClassIndex = this.getInputFormat().classIndex();
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j == newClassIndex || !att.isNumeric() || !this.m_Cols.isInRange(j)) {
                newAtts.add(att);
                continue;
            }
            StringBuffer attributeName = new StringBuffer(att.name() + "_binarized");
            ArrayList<String> vals = new ArrayList<String>(2);
            vals.add("0");
            vals.add("1");
            Attribute a = new Attribute(attributeName.toString(), vals);
            a.setWeight(att.weight());
            newAtts.add(a);
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void convertInstance(Instance instance) {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] newIndices = new int[instance.numValues()];
            for (int j = 0; j < instance.numValues(); ++j) {
                Attribute att = this.getInputFormat().attribute(instance.index(j));
                vals[j] = !att.isNumeric() || instance.index(j) == this.getInputFormat().classIndex() || !this.m_Cols.isInRange(instance.index(j)) ? instance.valueSparse(j) : (instance.isMissingSparse(j) ? instance.valueSparse(j) : 1.0);
                newIndices[j] = instance.index(j);
            }
            inst = new SparseInstance(instance.weight(), vals, newIndices, this.outputFormatPeek().numAttributes());
        } else {
            double[] vals = new double[this.outputFormatPeek().numAttributes()];
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                Attribute att = this.getInputFormat().attribute(j);
                vals[j] = !att.isNumeric() || j == this.getInputFormat().classIndex() || !this.m_Cols.isInRange(j) ? instance.value(j) : (instance.isMissing(j) || instance.value(j) == 0.0 ? instance.value(j) : 1.0);
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst, false);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] argv) {
        NumericToBinary.runFilter(new NumericToBinary(), argv);
    }
}

