/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright 2003 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "parser.h"

#define INITIAL 0
#define mediaquery 1
#define at_rule 2
#define block 3

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 65
#define YY_END_OF_BUFFER 66
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[408] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   66,   64,
        2,    2,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   50,   64,   64,   14,   14,   14,   64,   64,
       58,   64,   64,   64,   50,   63,   14,   14,   14,   62,
       60,   59,   64,   61,    2,    0,    0,    0,   13,    0,
        0,   17,    0,    8,    0,    0,    9,    0,   15,    0,
       14,   14,    0,   51,    0,   49,    0,    0,   50,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   15,   48,
       48,   43,    0,   48,    0,    0,    0,    0,    0,    0,
        0,    0,   55,   14,    0,    0,    0,   14,   14,    0,

       14,   14,   14,    7,    6,    5,   51,    0,   50,   48,
       14,   14,   14,    0,   17,    0,    0,    0,   13,    0,
        0,   17,    0,   17,   17,    0,    0,   13,    0,    0,
        4,    0,    0,   48,    0,   34,   48,   30,   32,   48,
       44,   36,   48,   35,   42,   48,   38,   37,   33,   48,
       48,   48,   48,    0,    0,    0,    0,    0,    0,    0,
        0,   14,   14,    0,   15,   14,   14,   56,   56,   14,
       14,   48,   12,   10,   14,    0,   17,    0,    0,    0,
       17,   17,   17,    0,    0,    0,    1,   48,   48,   39,
       48,   47,   15,   40,   48,   48,    3,    0,    0,    0,

        0,    0,    0,    0,   14,   52,    0,   56,   56,   56,
       55,   14,   48,   45,   11,   16,   16,    0,    0,   17,
       17,    0,    0,    0,   48,   41,   48,   48,    0,    0,
        0,    0,    0,    0,   19,   14,   57,   56,   56,   56,
       56,    0,    0,    0,    0,   54,    0,   14,   46,    0,
       17,    0,    0,   17,   17,    0,   48,   48,   31,    0,
        0,    0,    0,   20,    0,   14,   57,   56,   56,   56,
       56,   56,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   54,    0,    0,   14,    0,   17,    0,    0,   17,
       17,    0,   48,   48,    0,    0,    0,   18,    0,   14,

       57,   56,   56,   56,   56,   56,   56,    0,   53,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       14,   16,   16,    0,    0,   17,   17,    0,   48,   48,
        0,   22,    0,    0,   14,   57,   56,   56,   56,   56,
       56,   56,   56,    0,   53,    0,    0,    0,   53,    0,
        0,    0,    0,   17,   48,    0,    0,    0,    0,    0,
        0,    0,   57,    0,    0,    0,   29,    0,    0,    0,
        0,    0,   21,   23,   57,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   24,    0,
        0,    0,    0,   25,    0,    0,   26,    0,    0,    0,

        0,    0,    0,    0,   27,   28,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   37,   50,   51,   52,
       12,   53,   12,   54,   55,   12,   56,   29,   57,   58,

       59,   60,   61,   62,   63,   37,   64,   65,   66,   67,
       68,   69,   70,   71,   72,   73,   74,   75,   37,   76,
       77,   78,   79,   80,   81,   82,    1,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83
    } ;

static yyconst flex_int32_t yy_meta[84] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    9,    9,
        9,    9,    9,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,    4,   10,    9,    9,    9,    9,    9,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,    4,    4,
        4,    4,   10
    } ;

static yyconst flex_int16_t yy_base[441] =
    {   0,
        0,    0,   65,   69,   63,   67,   83,   86, 1201, 2820,
       96,  110,  124,   86,   78, 1176,   90, 1145,   83,   99,
     1134, 1138,  177, 1146,  243,   94,  260,  254,  259, 1115,
     2820, 1096, 1095, 1097,  132, 2820,  104,  318,  108, 2820,
     2820, 2820,  369, 2820,  174,  291,   69,  115, 2820,  428,
      101, 1056,  309, 2820,  121,  487, 2820,  117,  341, 1083,
      141,  371,  351,  329, 1062, 2820,  955,  986,    0,  936,
      116,  138,  232,  128,  300,  350,  359,  397,  449,  448,
      203,  866,  501,  130,  900,  237,  124,  263,  289,  302,
      144,  336, 2820,  342,  520,  508,  533,  560,  391,  882,

      409,  392,  612, 2820, 2820, 2820,  552,  885,  449,  440,
      541,  554,  556,  618,  658,  350,  412,  261,  273,  717,
      776,  819,  671,  817,  835,  572,  298,  422,  894,  953,
     2820,  844,  173,  806,  677,  805,  443,  804,  802,  386,
      750,  714,  534,  700,  691,  632,  690,  659,  643,  538,
      642, 1012,  453,  665,  378,  390,  406,  513,  445,  557,
      550,  514, 1071,  652,  661,  608,  575,  331,  655,  578,
      730,  762,  606,  610,  718,  821,  854,  562,  426,  911,
      611, 1130,  966,  671,  972,  646, 2820,  607, 1189,  555,
      741,  552,  579,  550, 1025,  732, 2820,  620,  668,  679,

      698,  705,  723,  724, 1031, 2820, 1065,  572,  562,  516,
      808, 1084,  777,  441,  740, 1117, 1175,  751, 1195, 1208,
     1229, 1242,  455,  586, 1248,  388, 1262,  778,  760,  755,
      398,  757,  624,  774, 2820, 1282, 1295,  739,  378,  337,
      336, 1354, 1368,  474,  835, 2820, 1420, 1356,  280, 1426,
     1439,  798, 1460, 1473, 1479, 1493, 1513, 1526,  251,  808,
      830,  841,  829, 2820,  847, 1546, 1559,  891,  244,  241,
      232,  231,  931,  689,  957, 1618,  892, 1677, 1389, 1630,
     1650, 1689, 1741, 1800, 1760, 1806, 1819,  638, 1840, 1853,
     1859, 1873, 1893, 1906,  186,  856,  892, 2820,  893, 1926,

     1939,  912,  177,  176,  175,  166,  115,  973, 2820, 1103,
      816, 1329, 1998, 2057, 1365,  967, 1710, 2116, 2175, 2234,
     1984, 2820, 2017,  923, 2074, 2133, 1032, 2194, 2240, 2253,
     2274, 2820,  874,  935, 1045, 2296,   87, 2820, 2820, 2820,
     2820, 2820, 2820, 1972,  920, 1013, 2329, 2361, 1014, 1026,
     2349, 2362, 1079, 1162, 1176, 1048, 1078, 1109, 1138,  963,
     1139, 1140, 2395, 2408, 2414, 2428, 2820, 1154, 1154, 1191,
     1278, 1310, 2820, 2820, 2820, 2448, 2461, 2481, 1325, 1179,
     1250, 1304, 1331, 2494, 2514, 2527, 1334, 1371, 2820, 1373,
     1377, 1558, 1715, 2820, 1367, 1370, 2820, 1371, 1378, 1406,

     1395, 1416, 1522, 1530, 2820, 2820, 2820, 2586, 2591, 2600,
     2605, 2611, 2618, 2627, 2632, 2639, 2648, 2658, 2660, 2665,
     2672, 2679, 2683, 2689, 2699, 2706, 2711, 2720, 2725, 2733,
     2743, 2748, 2756, 2765, 2774, 2779, 2787, 2796, 2801, 2809
    } ;

static yyconst flex_int16_t yy_def[441] =
    {   0,
      407,    1,    1,    1,    1,    1,    1,    1,  407,  407,
      407,  407,  407,  408,  409,  407,  410,  407,  407,  411,
      407,  407,  407,  407,  407,  412,  412,  412,  413,  407,
      407,  407,  407,  407,   23,  407,  412,  412,  412,  407,
      407,  407,  409,  407,  407,  407,  407,  408,  407,  414,
      409,  415,  416,  407,  410,  417,  407,  407,  407,  407,
      412,  412,  413,   23,  418,  407,  419,  407,   23,  420,
      420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
      420,  420,  421,  420,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  412,  422,  407,  407,  412,  412,  423,

      412,  412,  412,  407,  407,  407,   23,  407,   23,  420,
      412,  412,  412,  407,  415,  407,  408,  408,  408,  408,
      414,  415,  424,  415,  115,  410,  410,  410,  410,  417,
      407,  418,  425,  420,  426,  420,  420,  420,  420,  420,
      420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
      420,  420,  420,  407,  407,  407,  407,  407,  407,  407,
      407,  412,  103,  407,  407,  412,  412,  427,  407,  412,
      103,  420,  412,  412,  412,  407,  115,  407,  408,  120,
      415,  115,  125,  410,  129,  428,  407,  420,  152,  420,
      420,  420,  420,  420,  152,  420,  407,  407,  407,  407,

      407,  407,  407,  407,  163,  407,  407,  429,  407,  407,
      430,  103,  420,  420,  412,  407,  115,  407,  120,  182,
      125,  129,  428,  431,  189,  420,  152,  420,  407,  407,
      407,  407,  407,  407,  407,  163,  407,  432,  407,  407,
      407,  430,  430,  433,  434,  407,  435,  103,  420,  407,
      115,  407,  120,  182,  125,  129,  189,  152,  420,  407,
      407,  407,  407,  407,  407,  163,  407,  436,  407,  407,
      407,  407,  407,  433,  407,  437,  434,  438,  430,  430,
      430,  430,  430,  435,  248,  407,  115,  407,  120,  182,
      125,  129,  189,  152,  407,  407,  407,  407,  407,  163,

      407,  439,  407,  407,  407,  407,  407,  407,  407,  433,
      433,  433,  433,  437,  434,  434,  434,  434,  440,  430,
      285,  407,  115,  407,  120,  182,  323,  129,  189,  152,
      407,  407,  407,  407,  321,  407,  407,  407,  407,  407,
      407,  407,  407,  433,  433,  433,  313,  434,  434,  434,
      318,  320,  407,  323,  330,  407,  407,  407,  407,  407,
      407,  407,  407,  313,  318,  320,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  313,  318,  320,  407,  407,
      407,  407,  407,  313,  318,  320,  407,  407,  407,  407,
      407,  433,  434,  407,  407,  407,  407,  407,  407,  407,

      407,  407,  407,  407,  407,  407,    0,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407
    } ;

static yyconst flex_int16_t yy_nxt[2904] =
    {   0,
       10,   11,   12,   11,   11,   11,   13,   14,   15,   16,
       10,   10,   17,   10,   10,   18,   19,   20,   21,   22,
       23,   10,   24,   10,   10,   10,   25,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       27,   26,   26,   26,   26,   26,   26,   28,   26,   26,
       26,   26,   29,   30,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   27,   26,   26,   26,
       26,   26,   26,   28,   26,   26,   26,   26,   31,   32,
       10,   33,   26,   34,   41,   35,   36,   34,   41,   35,
       36,   43,   37,   49,   43,   51,   37,   45,   45,   45,

       45,   45,   49,   58,  207,   38,   39,   93,  116,   38,
       39,   45,   45,   45,   45,   45,   60,   93,  407,   58,
       37,   93,   49,   59,   37,   46,   46,   46,   46,   46,
       53,   38,   39,   49,  116,   38,   39,   58,   50,   62,
      343,   42,   56,   40,  111,   42,   95,   40,  113,   59,
      108,   63,  109,   53,   93,  136,   95,   59,  156,   47,
       95,   10,  110,   44,   10,   62,   44,   50,  135,  137,
      111,  160,  140,   56,  113,   45,   45,   45,   45,   45,
      135,  136,  135,   59,  153,  156,   47,   66,  133,  110,
      135,  342,  187,   95,   67,   68,  137,   69,  140,  160,

      341,  340,  339,  331,   70,   70,   71,   72,   73,   70,
       74,   75,   76,   70,   77,   70,   78,   79,   70,   80,
       70,   81,   82,   70,   70,   70,   70,   70,   70,   83,
      150,   84,   70,   71,   72,   73,   70,   74,   75,   76,
       77,   70,   78,   79,   70,   80,   70,   81,   82,   70,
       70,   70,   70,   70,   70,  135,  307,  306,  150,   70,
       86,   96,   96,   96,   96,   96,  305,   93,   49,  304,
      100,  138,   87,   93,  155,   88,   97,   98,   89,  103,
       49,  139,   90,   91,  135,   92,  103,  103,  103,  103,
      103,  103,   46,   46,   46,   46,   46,  138,  101,   87,

      155,   99,   88,  135,  157,   89,   95,  139,   90,   91,
       49,   92,   95,   50,  103,  103,  103,  103,  103,   96,
       96,   96,   96,   96,  101,   50,   47,   99,  158,  125,
      157,   93,  135,  159,   97,   98,  125,  125,  125,  125,
      125,  125,   96,   96,   96,   96,   96,  407,  207,   64,
       56,  141,  135,   47,  158,   93,  209,   97,   97,  112,
      159,  272,  271,  161,  125,  125,  125,  125,  125,   70,
       95,  103,   96,   96,   96,   96,   96,  141,  103,  103,
      103,  103,  103,  103,   93,  112,   51,   97,   98,  114,
      142,  161,  178,  143,   95,   70,  115,  115,  115,  115,

      115,  115,  135,  270,   93,   93,  103,  103,  103,  103,
      103,  135,  198,  191,   48,  262,  142,  199,  178,   49,
      143,   53,   93,   95,  115,  115,  115,  115,  115,   48,
       48,   48,  117,   49,   49,  119,  144,  167,  135,  198,
      135,  191,  145,   95,   95,  199,  200,  170,  120,  135,
       96,   96,   96,   96,   96,  120,  120,  120,  120,  120,
      120,   95,  144,  167,   50,   97,  146,  108,  145,  109,
      224,  137,  200,  170,   56,  202,  190,  147,   50,  110,
      121,  275,  172,  120,  120,  120,  120,  120,   55,   55,
       55,  126,  135,  135,  148,  135,  196,  149,  137,  128,

      135,  135,  202,  190,  147,  135,  110,  129,  172,   96,
       96,   96,   96,   96,  129,  129,  129,  129,  129,  129,
      148,  152,  196,  149,   97,   97,  276,   93,  152,  152,
      152,  152,  152,  152,  164,  164,  164,  164,  164,  130,
      163,  241,  129,  129,  129,  129,  129,  163,  163,  163,
      163,  163,  163,  165,   93,  201,  152,  152,  152,  152,
      152,  164,  164,  164,  164,  164,   95,   93,  194,   93,
      407,  173,  107,   93,   55,  163,  163,  163,  163,  163,
      166,  201,  110,  204,   49,  192,  135,  240,  206,  207,
      135,  211,   70,   95,  175,  194,  203,  239,  173,  193,

      174,  224,  135,  218,  135,  187,   95,  135,   95,  110,
      204,  192,   95,  102,  102,  102,  102,  102,   70,   93,
      175,   93,  203,  206,   56,   93,  174,   95,  166,  218,
       95,  135,  171,  164,  164,  164,  164,  164,  176,  171,
      171,  171,  171,  171,  171,  176,  176,  176,  176,  176,
      176,  264,  193,  164,  164,  164,  164,  164,   95,  135,
       95,  224,   95,  123,   95,  324,  229,  171,  171,  171,
      171,  171,  165,  176,  176,  176,  176,  176,  177,  264,
      210,  165,  197,   49,  135,  177,  177,  177,  177,  177,
      177,  182,  229,  324,  135,  135,  275,  189,  182,  182,

      182,  182,  182,  182,  189,  189,  189,  189,  189,  189,
      123,  135,  230,  177,  177,  177,  177,  177,  118,  179,
      179,  179,  118,   56,   49,  231,  182,  182,  182,  182,
      182,   93,  189,  189,  189,  189,  189,  180,  230,  232,
      233,  276,  135,  135,  180,  180,  180,  180,  180,  180,
      212,  231,  135,   93,  234,  235,  207,  212,  212,  212,
      212,  212,  212,  228,  269,  232,  135,  233,  215,   50,
       95,  226,  180,  180,  180,  180,  180,   48,   48,   48,
      117,  234,  235,  119,  135,  212,  212,  212,  212,  212,
      228,  213,   95,  135,  215,  252,  120,  214,  226,  260,

      261,  263,  135,  120,  120,  120,  120,  120,  120,  242,
      242,  242,  242,  242,  135,  244,  249,  259,  213,  265,
      245,  252,  246,  275,  214,  260,  261,  263,  121,  135,
      135,  120,  120,  120,  120,  120,  124,  124,  124,  124,
      124,  216,  249,  259,  288,  265,  295,  275,  216,  216,
      216,  216,  216,  216,  135,  183,  135,  135,  135,  133,
      247,  296,  183,  183,  183,  183,  183,  183,  276,  123,
      288,  123,  295,  297,  217,  298,  216,  216,  216,  216,
      216,  217,  217,  217,  217,  217,  217,  278,  296,  299,
      183,  183,  183,  183,  183,  127,  184,  184,  184,  127,

      297,  298,  332,  361,  275,  107,   49,  169,  207,  217,
      217,  217,  217,  217,  185,  299,  303,  154,  135,  333,
      334,  185,  185,  185,  185,  185,  185,  275,  332,  207,
      361,  219,  273,  273,  273,  273,  273,  338,  219,  219,
      219,  219,  219,  219,  278,  246,   56,  333,  334,  185,
      185,  185,  185,  185,   55,   55,   55,  126,  308,  308,
      308,  308,  308,  353,  362,  128,  219,  219,  219,  219,
      219,  309,  276,  129,  308,  308,  308,  308,  308,  275,
      129,  129,  129,  129,  129,  129,  221,  309,  135,  353,
      372,  362,  222,  221,  221,  221,  221,  221,  221,  222,

      222,  222,  222,  222,  222,  130,   64,   83,  129,  129,
      129,  129,  129,  151,  151,  151,  151,  151,  372,  278,
      275,  221,  221,  221,  221,  221,  275,  222,  222,  222,
      222,  222,  195,  124,  124,  124,  124,  124,  275,  195,
      195,  195,  195,  195,  195,  227,  162,  162,  162,  162,
      162,  236,  227,  227,  227,  227,  227,  227,  236,  236,
      236,  236,  236,  236,  135,  276,  278,  195,  195,  195,
      195,  195,  162,  162,  162,  162,  162,  133,  278,  368,
      227,  227,  227,  227,  227,  237,  236,  236,  236,  236,
      236,  205,  237,  237,  237,  237,  237,  237,  205,  205,

      205,  205,  205,  205,  248,  274,  368,  131,  123,  369,
      275,  248,  248,  248,  248,  248,  248,  107,  106,  105,
      237,  237,  237,  237,  237,  367,  205,  205,  205,  205,
      205,  181,  181,  181,  181,  181,  369,  250,  104,  248,
      248,  248,  248,  248,  250,  250,  250,  250,  250,  250,
      220,  367,   85,   65,   64,  276,  370,  220,  220,  220,
      220,  220,  220,  181,  181,  181,  181,  181,   57,  371,
      373,  374,  250,  250,  250,  250,  250,  188,  188,  188,
      188,  188,  370,  379,  380,  220,  220,  220,  220,  220,
      188,  188,  188,  188,  188,  251,  371,  373,  374,   54,

      407,  407,  251,  251,  251,  251,  251,  251,  407,  225,
      379,  380,  407,  407,  388,  253,  225,  225,  225,  225,
      225,  225,  253,  253,  253,  253,  253,  253,  254,  381,
      251,  251,  251,  251,  251,  254,  254,  254,  254,  254,
      254,  388,  407,  407,  225,  225,  225,  225,  225,  255,
      253,  253,  253,  253,  253,  381,  255,  255,  255,  255,
      255,  255,  256,  254,  254,  254,  254,  254,  257,  256,
      256,  256,  256,  256,  256,  257,  257,  257,  257,  257,
      257,  389,  258,  407,  255,  255,  255,  255,  255,  258,
      258,  258,  258,  258,  258,  407,  407,  256,  256,  256,

      256,  256,  266,  257,  257,  257,  257,  257,  389,  266,
      266,  266,  266,  266,  266,  267,  382,  258,  258,  258,
      258,  258,  267,  267,  267,  267,  267,  267,  407,  407,
      344,  308,  308,  308,  344,  390,  275,  266,  266,  266,
      266,  266,  382,  345,  407,  407,  407,  407,  383,  407,
      267,  267,  267,  267,  267,  242,  242,  242,  242,  242,
      407,  244,  390,  387,  407,  407,  245,  277,  246,  273,
      273,  273,  273,  273,  383,  407,  285,  275,  391,  394,
      407,  276,  246,  285,  285,  285,  285,  285,  285,  387,
      273,  273,  273,  273,  273,  407,  407,  407,  395,  407,

      407,  407,  396,  246,  391,  394,  247,  407,  397,  407,
      398,  285,  285,  285,  285,  285,  399,  278,  400,  401,
      247,  273,  273,  273,  273,  279,  395,  281,  407,  396,
      407,  407,  281,  281,  282,  397,  398,  402,  407,  403,
      283,  247,  399,  407,  400,  401,  286,  283,  283,  283,
      283,  283,  283,  286,  286,  286,  286,  286,  286,  287,
      404,  407,  407,  407,  402,  403,  287,  287,  287,  287,
      287,  287,  284,  407,  407,  283,  283,  283,  283,  283,
      289,  286,  286,  286,  286,  286,  404,  289,  289,  289,
      289,  289,  289,  290,  287,  287,  287,  287,  287,  291,

      290,  290,  290,  290,  290,  290,  291,  291,  291,  291,
      291,  291,  407,  292,  407,  289,  289,  289,  289,  289,
      292,  292,  292,  292,  292,  292,  407,  407,  290,  290,
      290,  290,  290,  293,  291,  291,  291,  291,  291,  407,
      293,  293,  293,  293,  293,  293,  294,  407,  292,  292,
      292,  292,  292,  294,  294,  294,  294,  294,  294,  311,
      346,  346,  346,  311,  407,  275,  300,  405,  293,  293,
      293,  293,  293,  300,  300,  300,  300,  300,  300,  301,
      406,  294,  294,  294,  294,  294,  301,  301,  301,  301,
      301,  301,  407,  405,  407,  407,  407,  407,  407,  407,

      407,  300,  300,  300,  300,  300,  406,  407,  407,  407,
      276,  407,  407,  407,  301,  301,  301,  301,  301,  274,
      274,  274,  310,  407,  407,  312,  407,  407,  407,  407,
      407,  273,  273,  273,  273,  273,  407,  407,  313,  407,
      407,  407,  407,  407,  246,  313,  313,  313,  313,  313,
      313,  273,  273,  273,  273,  273,  407,  407,  407,  407,
      407,  407,  407,  407,  246,  407,  407,  407,  407,  407,
      314,  407,  407,  313,  313,  313,  313,  313,  277,  277,
      277,  315,  247,  407,  407,  407,  407,  407,  407,  317,
      273,  273,  273,  273,  273,  407,  407,  318,  407,  407,

      407,  407,  247,  246,  318,  318,  318,  318,  318,  318,
      407,  348,  308,  308,  308,  348,  316,  350,  350,  350,
      316,  407,  275,  407,  349,  407,  407,  275,  407,  319,
      407,  407,  318,  318,  318,  318,  318,  407,  407,  407,
      407,  247,  279,  279,  279,  279,  279,  407,  407,  407,
      407,  407,  407,  407,  407,  246,  407,  407,  407,  407,
      407,  320,  278,  407,  407,  407,  407,  278,  320,  320,
      320,  320,  320,  320,  407,  407,  407,  407,  407,  407,
      321,  407,  407,  407,  407,  407,  407,  321,  321,  321,
      321,  321,  321,  247,  407,  407,  320,  320,  320,  320,

      320,  273,  273,  273,  273,  279,  407,  281,  407,  407,
      407,  407,  281,  281,  282,  321,  321,  321,  321,  321,
      283,  407,  407,  407,  407,  407,  322,  283,  283,  283,
      283,  283,  283,  322,  322,  322,  322,  322,  322,  323,
      407,  407,  407,  407,  407,  407,  323,  323,  323,  323,
      323,  323,  284,  407,  407,  283,  283,  283,  283,  283,
      325,  322,  322,  322,  322,  322,  407,  325,  325,  325,
      325,  325,  325,  326,  323,  323,  323,  323,  323,  327,
      326,  326,  326,  326,  326,  326,  327,  327,  327,  327,
      327,  327,  407,  328,  407,  325,  325,  325,  325,  325,

      328,  328,  328,  328,  328,  328,  407,  407,  326,  326,
      326,  326,  326,  329,  327,  327,  327,  327,  327,  407,
      329,  329,  329,  329,  329,  329,  330,  407,  328,  328,
      328,  328,  328,  330,  330,  330,  330,  330,  330,  407,
      407,  407,  407,  407,  407,  407,  335,  407,  329,  329,
      329,  329,  329,  335,  335,  335,  335,  335,  335,  336,
      407,  330,  330,  330,  330,  330,  336,  336,  336,  336,
      336,  336,  407,  344,  308,  308,  308,  344,  407,  275,
      407,  335,  335,  335,  335,  335,  345,  407,  407,  407,
      407,  407,  407,  407,  336,  336,  336,  336,  336,  311,

      346,  346,  346,  311,   94,  275,  407,  407,  407,  407,
      407,   94,   94,   94,   94,   94,   94,  407,  347,  407,
      407,  407,  407,  407,  276,  347,  347,  347,  347,  347,
      347,  407,  407,  407,  407,  407,  407,  122,  407,   94,
       94,   94,   94,   94,  122,  122,  122,  122,  122,  122,
      276,  407,  407,  347,  347,  347,  347,  347,  274,  274,
      274,  310,  407,  407,  312,  407,  407,  407,  407,  407,
      407,  407,  122,  122,  122,  122,  122,  313,  407,  407,
      407,  407,  407,  407,  313,  313,  313,  313,  313,  313,
      407,  407,  407,  407,   48,  407,  407,  407,  407,  407,

      407,   48,   48,   48,   48,   48,   48,  407,  407,  314,
      407,  407,  313,  313,  313,  313,  313,  316,  350,  350,
      350,  316,  407,  407,  407,  407,  407,  407,  275,   48,
       48,   48,   48,   48,  407,  407,  351,  407,  407,  407,
      407,  407,  407,  351,  351,  351,  351,  351,  351,  407,
      407,  407,  407,  354,  407,  407,  407,  407,  407,  407,
      354,  354,  354,  354,  354,  354,  407,  407,  278,  407,
      407,  351,  351,  351,  351,  351,  277,  277,  277,  315,
      407,  407,  407,  407,  407,  407,  407,  317,  354,  354,
      354,  354,  354,  407,  407,  318,  407,  407,  407,  407,

      407,  407,  318,  318,  318,  318,  318,  318,  407,  407,
      407,  407,  407,  407,   55,  407,  407,  407,  407,  407,
      407,   55,   55,   55,   55,   55,   55,  319,  407,  407,
      318,  318,  318,  318,  318,  279,  279,  279,  279,  279,
      407,  407,  407,  407,  407,  407,  407,  407,  246,   55,
       55,   55,   55,   55,  352,  407,  407,  407,  407,  407,
      355,  352,  352,  352,  352,  352,  352,  355,  355,  355,
      355,  355,  355,  134,  407,  407,  407,  407,  407,  407,
      134,  134,  134,  134,  134,  134,  247,  407,  407,  352,
      352,  352,  352,  352,  407,  355,  355,  355,  355,  355,

      407,  407,  407,  407,  356,  407,  407,  407,  134,  134,
      134,  134,  134,  357,  407,  407,  363,  407,  358,  359,
      407,  407,  360,  363,  363,  363,  363,  363,  363,  407,
      407,  356,  407,  407,  407,  407,  407,  407,  407,  357,
      407,  407,  407,  407,  358,  359,  407,  407,  360,  364,
      407,  363,  363,  363,  363,  363,  364,  364,  364,  364,
      364,  364,  348,  308,  308,  308,  348,  407,  407,  365,
      407,  407,  407,  275,  407,  349,  365,  365,  365,  365,
      365,  365,  366,  407,  364,  364,  364,  364,  364,  366,
      366,  366,  366,  366,  366,  407,  407,  407,  407,  407,

      407,  407,  407,  407,  365,  365,  365,  365,  365,  407,
      407,  407,  407,  278,  407,  375,  407,  366,  366,  366,
      366,  366,  375,  375,  375,  375,  375,  375,  376,  407,
      407,  407,  407,  407,  377,  376,  376,  376,  376,  376,
      376,  377,  377,  377,  377,  377,  377,  407,  378,  407,
      375,  375,  375,  375,  375,  378,  378,  378,  378,  378,
      378,  407,  407,  376,  376,  376,  376,  376,  384,  377,
      377,  377,  377,  377,  407,  384,  384,  384,  384,  384,
      384,  385,  407,  378,  378,  378,  378,  378,  385,  385,
      385,  385,  385,  385,  407,  407,  407,  407,  407,  407,

      407,  386,  407,  384,  384,  384,  384,  384,  386,  386,
      386,  386,  386,  386,  392,  407,  385,  385,  385,  385,
      385,  392,  392,  392,  392,  392,  392,  407,  407,  407,
      407,  407,  407,  407,  393,  407,  386,  386,  386,  386,
      386,  393,  393,  393,  393,  393,  393,  243,  407,  392,
      392,  392,  392,  392,  243,  243,  243,  243,  243,  243,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  393,
      393,  393,  393,  393,  407,  407,  407,  407,  407,  407,
      407,  407,  243,  243,  243,  243,  243,   48,  407,   48,
       48,   48,   48,   48,   48,   48,   52,  407,  407,   52,

       52,   55,  407,   55,   55,   55,   55,   55,   55,   55,
       61,   61,  407,   61,   61,   94,   94,   94,  407,   94,
       94,  102,  102,  102,  102,  102,  102,  102,  118,  118,
      118,  118,  118,  118,  118,  118,  118,  122,  122,  407,
      122,  122,  124,  124,  124,  124,  124,  124,  124,  127,
      127,  127,  127,  127,  127,  127,  127,  127,  132,  132,
      132,  132,  132,  132,  132,  132,  132,  132,   70,   70,
      134,  134,  407,  134,  134,  151,  151,  151,  151,  151,
      151,  151,  162,  162,  162,  162,  162,  162,  162,  168,
      168,  168,  181,  181,  181,  181,  181,  181,  181,  186,

      186,  186,  186,  186,  186,  186,  186,  186,  186,  188,
      188,  188,  188,  188,  188,  188,  208,  208,  208,  208,
      223,  223,  223,  223,  223,  223,  223,  223,  223,  223,
      238,  238,  238,  238,  243,  243,  243,  407,  243,  243,
      243,  243,  243,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  186,  268,  268,  268,  268,  274,  407,  274,
      274,  274,  274,  274,  274,  274,  277,  407,  277,  277,
      277,  277,  277,  277,  277,  280,  280,  280,  280,  280,
      280,  280,  280,  280,  302,  302,  302,  302,  311,  311,
      311,  311,  311,  311,  311,  311,  311,  316,  316,  316,

      316,  316,  316,  316,  316,  316,  337,  337,  337,  337,
      316,  316,  316,  316,  316,  316,  316,  316,  316,    9,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,

      407,  407,  407
    } ;

static yyconst flex_int16_t yy_chk[2904] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    5,    3,    3,    4,    6,    4,
        4,    7,    3,   14,    8,   15,    4,   11,   11,   11,

       11,   11,   17,   19,  337,    3,    3,   26,   47,    4,
        4,   12,   12,   12,   12,   12,   20,   37,   51,   20,
        3,   39,   48,   19,    4,   13,   13,   13,   13,   13,
       15,    3,    3,   55,   47,    4,    4,   58,   14,   20,
      307,    5,   17,    3,   37,    6,   26,    4,   39,   19,
       35,   20,   35,   51,   61,   71,   37,   58,   87,   13,
       39,    7,   35,    7,    8,   20,    8,   48,   71,   72,
       37,   91,   74,   55,   39,   45,   45,   45,   45,   45,
       74,   71,   84,   58,   84,   87,   13,   23,  133,   35,
       72,  306,  133,   61,   23,   23,   72,   23,   74,   91,

      305,  304,  303,  295,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       81,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   81,  272,  271,   81,   23,
       25,   27,   27,   27,   27,   27,  270,   28,  118,  269,
       28,   73,   25,   27,   86,   25,   27,   27,   25,   29,
      119,   73,   25,   25,   73,   25,   29,   29,   29,   29,
       29,   29,   46,   46,   46,   46,   46,   73,   28,   25,

       86,   27,   25,  259,   88,   25,   28,   73,   25,   25,
      127,   25,   27,  118,   29,   29,   29,   29,   29,   38,
       38,   38,   38,   38,   28,  119,   46,   27,   89,   53,
       88,   38,  249,   90,   38,   38,   53,   53,   53,   53,
       53,   53,   59,   59,   59,   59,   59,   64,  168,   64,
      127,   75,   75,   46,   89,   94,  168,   59,   59,   38,
       90,  241,  240,   92,   53,   53,   53,   53,   53,   64,
       38,   63,   62,   62,   62,   62,   62,   75,   63,   63,
       63,   63,   63,   63,   62,   38,   43,   62,   62,   43,
       76,   92,  116,   77,   94,   64,   43,   43,   43,   43,

       43,   43,   76,  239,   99,  102,   63,   63,   63,   63,
       63,   77,  155,  140,  117,  231,   76,  156,  116,  117,
       77,   43,  101,   62,   43,   43,   43,   43,   43,   50,
       50,   50,   50,  179,  128,   50,   78,   99,  140,  155,
      226,  140,   78,   99,  102,  156,  157,  101,   50,   78,
       79,   79,   79,   79,   79,   50,   50,   50,   50,   50,
       50,  101,   78,   99,  117,   79,   79,  109,   78,  109,
      223,  110,  157,  101,  128,  159,  137,   80,  179,  109,
       50,  244,  110,   50,   50,   50,   50,   50,   56,   56,
       56,   56,  110,  214,   80,  137,  153,   80,  110,   56,

       80,   79,  159,  137,   80,  153,  109,   56,  110,   96,
       96,   96,   96,   96,   56,   56,   56,   56,   56,   56,
       80,   83,  153,   80,   96,   96,  244,  162,   83,   83,
       83,   83,   83,   83,   97,   97,   97,   97,   97,   56,
       95,  210,   56,   56,   56,   56,   56,   95,   95,   95,
       95,   95,   95,   97,  111,  158,   83,   83,   83,   83,
       83,   98,   98,   98,   98,   98,  162,  112,  150,  113,
      107,  111,  107,   98,  126,   95,   95,   95,   95,   95,
       98,  158,  107,  161,  126,  143,  143,  209,  167,  208,
      150,  170,  107,  111,  113,  150,  160,  208,  111,  193,

      112,  224,  194,  178,  192,  224,  112,  190,  113,  107,
      161,  143,   98,  103,  103,  103,  103,  103,  107,  173,
      113,  166,  160,  174,  126,  103,  112,  167,  166,  178,
      170,  193,  103,  146,  146,  146,  146,  146,  114,  103,
      103,  103,  103,  103,  103,  114,  114,  114,  114,  114,
      114,  233,  146,  164,  164,  164,  164,  164,  173,  188,
      166,  186,  174,  181,  103,  288,  198,  103,  103,  103,
      103,  103,  164,  114,  114,  114,  114,  114,  115,  233,
      169,  165,  154,  184,  146,  115,  115,  115,  115,  115,
      115,  123,  198,  288,  151,  149,  274,  135,  123,  123,

      123,  123,  123,  123,  135,  135,  135,  135,  135,  135,
      115,  148,  199,  115,  115,  115,  115,  115,  120,  120,
      120,  120,  120,  184,  120,  200,  123,  123,  123,  123,
      123,  175,  135,  135,  135,  135,  135,  120,  199,  201,
      202,  274,  147,  145,  120,  120,  120,  120,  120,  120,
      171,  200,  144,  215,  203,  204,  238,  171,  171,  171,
      171,  171,  171,  196,  238,  201,  142,  202,  175,  120,
      175,  191,  120,  120,  120,  120,  120,  121,  121,  121,
      121,  203,  204,  121,  196,  171,  171,  171,  171,  171,
      196,  172,  215,  191,  175,  218,  121,  172,  191,  229,

      230,  232,  141,  121,  121,  121,  121,  121,  121,  211,
      211,  211,  211,  211,  172,  211,  213,  228,  172,  234,
      211,  218,  211,  311,  172,  229,  230,  232,  121,  213,
      228,  121,  121,  121,  121,  121,  125,  125,  125,  125,
      125,  176,  213,  228,  252,  234,  260,  245,  176,  176,
      176,  176,  176,  176,  139,  125,  138,  136,  134,  132,
      211,  261,  125,  125,  125,  125,  125,  125,  311,  124,
      252,  122,  260,  262,  177,  263,  176,  176,  176,  176,
      176,  177,  177,  177,  177,  177,  177,  245,  261,  265,
      125,  125,  125,  125,  125,  129,  129,  129,  129,  129,

      262,  263,  296,  333,  277,  108,  129,  100,  268,  177,
      177,  177,  177,  177,  129,  265,  268,   85,   82,  297,
      299,  129,  129,  129,  129,  129,  129,  345,  296,  302,
      333,  180,  273,  273,  273,  273,  273,  302,  180,  180,
      180,  180,  180,  180,  277,  273,  129,  297,  299,  129,
      129,  129,  129,  129,  130,  130,  130,  130,  275,  275,
      275,  275,  275,  324,  334,  130,  180,  180,  180,  180,
      180,  275,  345,  130,  308,  308,  308,  308,  308,  316,
      130,  130,  130,  130,  130,  130,  183,  308,   70,  324,
      360,  334,  185,  183,  183,  183,  183,  183,  183,  185,

      185,  185,  185,  185,  185,  130,   68,   67,  130,  130,
      130,  130,  130,  152,  152,  152,  152,  152,  360,  316,
      346,  183,  183,  183,  183,  183,  349,  185,  185,  185,
      185,  185,  152,  327,  327,  327,  327,  327,  350,  152,
      152,  152,  152,  152,  152,  195,  335,  335,  335,  335,
      335,  205,  195,  195,  195,  195,  195,  195,  205,  205,
      205,  205,  205,  205,  152,  346,  349,  152,  152,  152,
      152,  152,  163,  163,  163,  163,  163,   65,  350,  356,
      195,  195,  195,  195,  195,  207,  205,  205,  205,  205,
      205,  163,  207,  207,  207,  207,  207,  207,  163,  163,

      163,  163,  163,  163,  212,  310,  356,   60,   52,  357,
      310,  212,  212,  212,  212,  212,  212,   34,   33,   32,
      207,  207,  207,  207,  207,  353,  163,  163,  163,  163,
      163,  182,  182,  182,  182,  182,  357,  216,   30,  212,
      212,  212,  212,  212,  216,  216,  216,  216,  216,  216,
      182,  353,   24,   22,   21,  310,  358,  182,  182,  182,
      182,  182,  182,  354,  354,  354,  354,  354,   18,  359,
      361,  362,  216,  216,  216,  216,  216,  355,  355,  355,
      355,  355,  358,  368,  369,  182,  182,  182,  182,  182,
      189,  189,  189,  189,  189,  217,  359,  361,  362,   16,

        9,    0,  217,  217,  217,  217,  217,  217,    0,  189,
      368,  369,    0,    0,  380,  219,  189,  189,  189,  189,
      189,  189,  219,  219,  219,  219,  219,  219,  220,  370,
      217,  217,  217,  217,  217,  220,  220,  220,  220,  220,
      220,  380,    0,    0,  189,  189,  189,  189,  189,  221,
      219,  219,  219,  219,  219,  370,  221,  221,  221,  221,
      221,  221,  222,  220,  220,  220,  220,  220,  225,  222,
      222,  222,  222,  222,  222,  225,  225,  225,  225,  225,
      225,  381,  227,    0,  221,  221,  221,  221,  221,  227,
      227,  227,  227,  227,  227,    0,    0,  222,  222,  222,

      222,  222,  236,  225,  225,  225,  225,  225,  381,  236,
      236,  236,  236,  236,  236,  237,  371,  227,  227,  227,
      227,  227,  237,  237,  237,  237,  237,  237,    0,    0,
      312,  312,  312,  312,  312,  382,  312,  236,  236,  236,
      236,  236,  371,  312,    0,    0,    0,    0,  372,    0,
      237,  237,  237,  237,  237,  242,  242,  242,  242,  242,
        0,  242,  382,  379,    0,    0,  242,  315,  242,  243,
      243,  243,  243,  243,  372,  243,  248,  315,  383,  387,
      243,  312,  243,  248,  248,  248,  248,  248,  248,  379,
      279,  279,  279,  279,  279,    0,  279,    0,  388,    0,

        0,  279,  390,  279,  383,  387,  242,    0,  391,    0,
      395,  248,  248,  248,  248,  248,  396,  315,  398,  399,
      243,  247,  247,  247,  247,  247,  388,  247,    0,  390,
        0,    0,  247,  247,  247,  391,  395,  400,    0,  401,
      247,  279,  396,    0,  398,  399,  250,  247,  247,  247,
      247,  247,  247,  250,  250,  250,  250,  250,  250,  251,
      402,    0,    0,    0,  400,  401,  251,  251,  251,  251,
      251,  251,  247,    0,    0,  247,  247,  247,  247,  247,
      253,  250,  250,  250,  250,  250,  402,  253,  253,  253,
      253,  253,  253,  254,  251,  251,  251,  251,  251,  255,

      254,  254,  254,  254,  254,  254,  255,  255,  255,  255,
      255,  255,    0,  256,    0,  253,  253,  253,  253,  253,
      256,  256,  256,  256,  256,  256,    0,    0,  254,  254,
      254,  254,  254,  257,  255,  255,  255,  255,  255,    0,
      257,  257,  257,  257,  257,  257,  258,    0,  256,  256,
      256,  256,  256,  258,  258,  258,  258,  258,  258,  392,
      392,  392,  392,  392,    0,  392,  266,  403,  257,  257,
      257,  257,  257,  266,  266,  266,  266,  266,  266,  267,
      404,  258,  258,  258,  258,  258,  267,  267,  267,  267,
      267,  267,    0,  403,    0,    0,    0,    0,    0,    0,

        0,  266,  266,  266,  266,  266,  404,    0,    0,    0,
      392,    0,    0,    0,  267,  267,  267,  267,  267,  276,
      276,  276,  276,    0,    0,  276,    0,    0,    0,    0,
        0,  280,  280,  280,  280,  280,    0,  280,  276,    0,
        0,    0,  280,    0,  280,  276,  276,  276,  276,  276,
      276,  281,  281,  281,  281,  281,    0,  281,    0,    0,
        0,    0,  281,    0,  281,    0,    0,    0,    0,    0,
      276,    0,    0,  276,  276,  276,  276,  276,  278,  278,
      278,  278,  280,    0,    0,    0,    0,    0,    0,  278,
      282,  282,  282,  282,  282,    0,  282,  278,    0,    0,

        0,  282,  281,  282,  278,  278,  278,  278,  278,  278,
        0,  317,  317,  317,  317,  317,  393,  393,  393,  393,
      393,    0,  317,    0,  317,    0,    0,  393,    0,  278,
        0,    0,  278,  278,  278,  278,  278,    0,    0,    0,
        0,  282,  283,  283,  283,  283,  283,    0,  283,    0,
        0,    0,    0,  283,    0,  283,    0,    0,    0,    0,
        0,  283,  317,    0,    0,    0,    0,  393,  283,  283,
      283,  283,  283,  283,    0,    0,    0,    0,    0,    0,
      285,    0,    0,    0,    0,    0,    0,  285,  285,  285,
      285,  285,  285,  283,    0,    0,  283,  283,  283,  283,

      283,  284,  284,  284,  284,  284,    0,  284,    0,    0,
        0,    0,  284,  284,  284,  285,  285,  285,  285,  285,
      284,    0,    0,    0,    0,    0,  286,  284,  284,  284,
      284,  284,  284,  286,  286,  286,  286,  286,  286,  287,
        0,    0,    0,    0,    0,    0,  287,  287,  287,  287,
      287,  287,  284,    0,    0,  284,  284,  284,  284,  284,
      289,  286,  286,  286,  286,  286,    0,  289,  289,  289,
      289,  289,  289,  290,  287,  287,  287,  287,  287,  291,
      290,  290,  290,  290,  290,  290,  291,  291,  291,  291,
      291,  291,    0,  292,    0,  289,  289,  289,  289,  289,

      292,  292,  292,  292,  292,  292,    0,    0,  290,  290,
      290,  290,  290,  293,  291,  291,  291,  291,  291,    0,
      293,  293,  293,  293,  293,  293,  294,    0,  292,  292,
      292,  292,  292,  294,  294,  294,  294,  294,  294,    0,
        0,    0,    0,    0,    0,    0,  300,    0,  293,  293,
      293,  293,  293,  300,  300,  300,  300,  300,  300,  301,
        0,  294,  294,  294,  294,  294,  301,  301,  301,  301,
      301,  301,    0,  344,  344,  344,  344,  344,    0,  344,
        0,  300,  300,  300,  300,  300,  344,    0,    0,    0,
        0,    0,    0,    0,  301,  301,  301,  301,  301,  313,

      313,  313,  313,  313,  321,  313,    0,    0,    0,    0,
        0,  321,  321,  321,  321,  321,  321,    0,  313,    0,
        0,    0,    0,    0,  344,  313,  313,  313,  313,  313,
      313,    0,    0,    0,    0,    0,    0,  323,    0,  321,
      321,  321,  321,  321,  323,  323,  323,  323,  323,  323,
      313,    0,    0,  313,  313,  313,  313,  313,  314,  314,
      314,  314,    0,    0,  314,    0,    0,    0,    0,    0,
        0,    0,  323,  323,  323,  323,  323,  314,    0,    0,
        0,    0,    0,    0,  314,  314,  314,  314,  314,  314,
        0,    0,    0,    0,  325,    0,    0,    0,    0,    0,

        0,  325,  325,  325,  325,  325,  325,    0,    0,  314,
        0,    0,  314,  314,  314,  314,  314,  318,  318,  318,
      318,  318,    0,    0,    0,    0,    0,    0,  318,  325,
      325,  325,  325,  325,    0,    0,  318,    0,    0,    0,
        0,    0,    0,  318,  318,  318,  318,  318,  318,    0,
        0,    0,    0,  326,    0,    0,    0,    0,    0,    0,
      326,  326,  326,  326,  326,  326,    0,    0,  318,    0,
        0,  318,  318,  318,  318,  318,  319,  319,  319,  319,
        0,    0,    0,    0,    0,    0,    0,  319,  326,  326,
      326,  326,  326,    0,    0,  319,    0,    0,    0,    0,

        0,    0,  319,  319,  319,  319,  319,  319,    0,    0,
        0,    0,    0,    0,  328,    0,    0,    0,    0,    0,
        0,  328,  328,  328,  328,  328,  328,  319,    0,    0,
      319,  319,  319,  319,  319,  320,  320,  320,  320,  320,
        0,  320,    0,    0,    0,    0,  320,    0,  320,  328,
      328,  328,  328,  328,  320,    0,    0,    0,    0,    0,
      329,  320,  320,  320,  320,  320,  320,  329,  329,  329,
      329,  329,  329,  330,    0,    0,    0,    0,    0,    0,
      330,  330,  330,  330,  330,  330,  320,    0,    0,  320,
      320,  320,  320,  320,    0,  329,  329,  329,  329,  329,

        0,    0,    0,    0,  331,    0,    0,    0,  330,  330,
      330,  330,  330,  331,    0,    0,  336,    0,  331,  331,
        0,    0,  331,  336,  336,  336,  336,  336,  336,    0,
        0,  331,    0,    0,    0,    0,    0,    0,    0,  331,
        0,    0,    0,    0,  331,  331,    0,    0,  331,  347,
        0,  336,  336,  336,  336,  336,  347,  347,  347,  347,
      347,  347,  348,  348,  348,  348,  348,    0,    0,  351,
        0,    0,    0,  348,    0,  348,  351,  351,  351,  351,
      351,  351,  352,    0,  347,  347,  347,  347,  347,  352,
      352,  352,  352,  352,  352,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  351,  351,  351,  351,  351,    0,
        0,    0,    0,  348,    0,  363,    0,  352,  352,  352,
      352,  352,  363,  363,  363,  363,  363,  363,  364,    0,
        0,    0,    0,    0,  365,  364,  364,  364,  364,  364,
      364,  365,  365,  365,  365,  365,  365,    0,  366,    0,
      363,  363,  363,  363,  363,  366,  366,  366,  366,  366,
      366,    0,    0,  364,  364,  364,  364,  364,  376,  365,
      365,  365,  365,  365,    0,  376,  376,  376,  376,  376,
      376,  377,    0,  366,  366,  366,  366,  366,  377,  377,
      377,  377,  377,  377,    0,    0,    0,    0,    0,    0,

        0,  378,    0,  376,  376,  376,  376,  376,  378,  378,
      378,  378,  378,  378,  384,    0,  377,  377,  377,  377,
      377,  384,  384,  384,  384,  384,  384,    0,    0,    0,
        0,    0,    0,    0,  385,    0,  378,  378,  378,  378,
      378,  385,  385,  385,  385,  385,  385,  386,    0,  384,
      384,  384,  384,  384,  386,  386,  386,  386,  386,  386,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  385,
      385,  385,  385,  385,    0,    0,    0,    0,    0,    0,
        0,    0,  386,  386,  386,  386,  386,  408,    0,  408,
      408,  408,  408,  408,  408,  408,  409,    0,    0,  409,

      409,  410,    0,  410,  410,  410,  410,  410,  410,  410,
      411,  411,    0,  411,  411,  412,  412,  412,    0,  412,
      412,  413,  413,  413,  413,  413,  413,  413,  414,  414,
      414,  414,  414,  414,  414,  414,  414,  415,  415,    0,
      415,  415,  416,  416,  416,  416,  416,  416,  416,  417,
      417,  417,  417,  417,  417,  417,  417,  417,  418,  418,
      418,  418,  418,  418,  418,  418,  418,  418,  419,  419,
      420,  420,    0,  420,  420,  421,  421,  421,  421,  421,
      421,  421,  422,  422,  422,  422,  422,  422,  422,  423,
      423,  423,  424,  424,  424,  424,  424,  424,  424,  425,

      425,  425,  425,  425,  425,  425,  425,  425,  425,  426,
      426,  426,  426,  426,  426,  426,  427,  427,  427,  427,
      428,  428,  428,  428,  428,  428,  428,  428,  428,  428,
      429,  429,  429,  429,  430,  430,  430,    0,  430,  430,
      430,  430,  430,  431,  431,  431,  431,  431,  431,  431,
      431,  431,  431,  432,  432,  432,  432,  433,    0,  433,
      433,  433,  433,  433,  433,  433,  434,    0,  434,  434,
      434,  434,  434,  434,  434,  435,  435,  435,  435,  435,
      435,  435,  435,  435,  436,  436,  436,  436,  437,  437,
      437,  437,  437,  437,  437,  437,  437,  438,  438,  438,

      438,  438,  438,  438,  438,  438,  439,  439,  439,  439,
      440,  440,  440,  440,  440,  440,  440,  440,  440,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  407,  407,

      407,  407,  407
    } ;

YY_DECL
{
	register yy_state_type yy_current_state;
	register unsigned short *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 408 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2820 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 30 "tokenizer.flex"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 32 "tokenizer.flex"
{yyTok = S; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 34 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 35 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 36 "tokenizer.flex"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 37 "tokenizer.flex"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 38 "tokenizer.flex"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 39 "tokenizer.flex"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 40 "tokenizer.flex"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 41 "tokenizer.flex"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 42 "tokenizer.flex"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 43 "tokenizer.flex"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 45 "tokenizer.flex"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "tokenizer.flex"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 47 "tokenizer.flex"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 50 "tokenizer.flex"
{yyTok = HEXCOLOR; return yyTok;}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 51 "tokenizer.flex"
{yyTok = HASH; return yyTok;}
	YY_BREAK
/* @rule tokens surrounding css declaration blocks with { } braces must start a BEGIN(at_rule) context */
case 18:
YY_RULE_SETUP
#line 53 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "tokenizer.flex"
{BEGIN(at_rule); yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "tokenizer.flex"
{BEGIN(at_rule); yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "tokenizer.flex"
{BEGIN(at_rule); yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "tokenizer.flex"
{BEGIN(at_rule); yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "tokenizer.flex"
{BEGIN(at_rule); yyTok = KHTML_RULE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "tokenizer.flex"
{yyTok = KHTML_DECLS_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "tokenizer.flex"
{yyTok = KHTML_VALUE_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "tokenizer.flex"
{yyTok = KHTML_SELECTORS_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = KHTML_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 65 "tokenizer.flex"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 67 "tokenizer.flex"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 68 "tokenizer.flex"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 69 "tokenizer.flex"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 70 "tokenizer.flex"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 71 "tokenizer.flex"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 72 "tokenizer.flex"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 73 "tokenizer.flex"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 74 "tokenizer.flex"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 75 "tokenizer.flex"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 76 "tokenizer.flex"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 77 "tokenizer.flex"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 78 "tokenizer.flex"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 79 "tokenizer.flex"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 80 "tokenizer.flex"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 81 "tokenizer.flex"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 82 "tokenizer.flex"
{yyTok = DPI; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 83 "tokenizer.flex"
{yyTok = DPCM; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 84 "tokenizer.flex"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 85 "tokenizer.flex"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 86 "tokenizer.flex"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 87 "tokenizer.flex"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 88 "tokenizer.flex"
{yyTok = FLOAT; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 91 "tokenizer.flex"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 92 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 93 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 94 "tokenizer.flex"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 96 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 97 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 99 "tokenizer.flex"
{BEGIN(block); yyTok = *yytext; return yyTok;}
	YY_BREAK
case 59:
#line 101 "tokenizer.flex"
case 60:
#line 102 "tokenizer.flex"
case 61:
#line 103 "tokenizer.flex"
case 62:
#line 104 "tokenizer.flex"
case 63:
YY_RULE_SETUP
#line 104 "tokenizer.flex"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 105 "tokenizer.flex"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 107 "tokenizer.flex"
ECHO;
	YY_BREAK
#line 1843 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(at_rule):
case YY_STATE_EOF(block):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
