/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.mirror.MirrorSite;
import org.eclipse.update.internal.mirror.MirrorSiteFactory;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class MirrorCommand
extends ScriptedCommand {
    private String featureId;
    private String featureVersion;
    private String fromSiteUrl;
    private String toSiteDir;
    private String mirrorURL;
    private MirrorSite mirrorSite;

    public MirrorCommand(String featureId, String featureVersion, String fromSiteUrl, String toSiteDir, String mirrorUrl) {
        this.featureId = featureId;
        this.featureVersion = featureVersion;
        this.fromSiteUrl = fromSiteUrl;
        this.toSiteDir = toSiteDir;
        this.mirrorURL = mirrorUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(IProgressMonitor monitor) {
        if (!this.validateParameters()) {
            return false;
        }
        try {
            if (this.getMirrorSite() == null) {
                boolean bl = false;
                return bl;
            }
            URL remoteSiteUrl = new URL(this.fromSiteUrl);
            ISite remoteSite = SiteManager.getSite(remoteSiteUrl, (IProgressMonitor)new NullProgressMonitor());
            ISiteFeatureReference[] featureReferencesToMirror = this.findFeaturesToMirror(remoteSite);
            if (featureReferencesToMirror.length == 0) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("No matching features found on " + remoteSiteUrl + ".", null));
                boolean bl = false;
                return bl;
            }
            this.mirrorSite.mirrorAndExpose(remoteSite, featureReferencesToMirror, null, this.mirrorURL);
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            boolean bl = false;
            return bl;
        }
        catch (CoreException ce) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(ce);
            boolean bl = false;
            return bl;
        }
        finally {
            JarContentReference.shutdown();
        }
    }

    private boolean validateParameters() {
        if (this.fromSiteUrl == null || this.fromSiteUrl.length() <= 0) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(Utilities.newCoreException("from parameter is missing.", null));
            return false;
        }
        try {
            new URL(this.fromSiteUrl);
        }
        catch (MalformedURLException mue) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(Utilities.newCoreException("from must be a valid URL", null));
            return false;
        }
        if (this.toSiteDir == null || this.toSiteDir.length() <= 0) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(Utilities.newCoreException("to parameter is missing.", null));
            return false;
        }
        return true;
    }

    private MirrorSite getMirrorSite() throws MalformedURLException, CoreException {
        if (this.mirrorSite == null) {
            if (this.toSiteDir != null) {
                MirrorSiteFactory factory = new MirrorSiteFactory();
                System.out.print("Analyzing features already mirrored ...");
                try {
                    this.mirrorSite = (MirrorSite)factory.createSite(new File(this.toSiteDir));
                }
                catch (InvalidSiteTypeException invalidSiteTypeException) {
                    // empty catch block
                }
                System.out.println("  Done.");
            }
            if (this.mirrorSite == null) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(Utilities.newCoreException("Mirror site at " + this.toSiteDir + " cannot be accessed.", null));
                return null;
            }
        }
        return this.mirrorSite;
    }

    private ISiteFeatureReference[] findFeaturesToMirror(ISite remoteSite) throws CoreException {
        ISiteFeatureReference[] remoteSiteFeatureReferences = remoteSite.getRawFeatureReferences();
        SiteFeatureReferenceModel[] existingFeatureModels = this.mirrorSite.getFeatureReferenceModels();
        ArrayList<ISiteFeatureReference> featureReferencesToMirror = new ArrayList<ISiteFeatureReference>();
        PluginVersionIdentifier featureVersionIdentifier = null;
        if (this.featureId == null) {
            System.out.println("Parameter feature not specified.  All features on the remote site will be mirrored.");
        }
        if (this.featureVersion == null) {
            System.out.println("Parameter version not specified.  All versions of features on the remote site will be mirrored.");
        } else {
            featureVersionIdentifier = new PluginVersionIdentifier(this.featureVersion);
        }
        for (int i = 0; i < remoteSiteFeatureReferences.length; ++i) {
            VersionedIdentifier remoteFeatureVersionedIdentifier = remoteSiteFeatureReferences[i].getVersionedIdentifier();
            if (this.featureId != null && !this.featureId.equals(remoteFeatureVersionedIdentifier.getIdentifier()) || featureVersionIdentifier != null && !featureVersionIdentifier.isPerfect(remoteFeatureVersionedIdentifier.getVersion())) continue;
            for (int e = 0; e < existingFeatureModels.length; ++e) {
                if (!existingFeatureModels[e].getVersionedIdentifier().equals(remoteFeatureVersionedIdentifier)) continue;
                System.out.println("Feature " + remoteFeatureVersionedIdentifier + " already mirrored and exposed.");
            }
            String type = ((SiteFeatureReference)remoteSiteFeatureReferences[i]).getType();
            if (type != null && !"org.eclipse.update.core.packaged".equals(type)) {
                throw Utilities.newCoreException("Feature " + remoteFeatureVersionedIdentifier + " is of type " + type + ".  Only features of type " + "org.eclipse.update.core.packaged" + " are supported.", null);
            }
            featureReferencesToMirror.add(remoteSiteFeatureReferences[i]);
            System.out.println("Feature " + remoteSiteFeatureReferences[i].getVersionedIdentifier() + " will be mirrored.");
        }
        return featureReferencesToMirror.toArray(new ISiteFeatureReference[featureReferencesToMirror.size()]);
    }
}

