/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaIndenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JavaFormatter {
    private static final String MARKER = "/*${cursor}*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;

    public JavaFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
    }

    public void format(TemplateBuffer buffer, TemplateContext context) throws BadLocationException {
        try {
            DocumentTemplateContext dtc;
            if (this.fUseCodeFormatter) {
                try {
                    this.format(buffer, (JavaContext)context);
                }
                catch (BadLocationException e) {
                    this.indent(buffer);
                }
                catch (MalformedTreeException e) {
                    this.indent(buffer);
                }
            } else {
                this.indent(buffer);
            }
            if (context instanceof DocumentTemplateContext && (dtc = (DocumentTemplateContext)context).getStart() == dtc.getCompletionOffset() && dtc.getDocument().get(dtc.getStart(), dtc.getEnd() - dtc.getEnd()).trim().length() == 0) {
                return;
            }
            JavaFormatter.trimBegin(buffer);
        }
        catch (MalformedTreeException e) {
            throw new BadLocationException();
        }
    }

    private static int getCaretOffset(TemplateVariable[] variables) {
        for (int i = 0; i != variables.length; ++i) {
            TemplateVariable variable = variables[i];
            if (!variable.getType().equals("cursor")) continue;
            return variable.getOffsets()[0];
        }
        return -1;
    }

    private boolean isInsideCommentOrString(String string, int offset) {
        Document document = new Document(string);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
        try {
            ITypedRegion partition = document.getPartition(offset);
            String partitionType = partition.getType();
            return partitionType != null && (partitionType.equals("__java_multiline_comment") || partitionType.equals("__java_singleline_comment") || partitionType.equals("__java_string") || partitionType.equals("__java_character") || partitionType.equals("__java_javadoc"));
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private void format(TemplateBuffer templateBuffer, JavaContext context) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] variables = templateBuffer.getVariables();
        int caretOffset = JavaFormatter.getCaretOffset(variables);
        if (caretOffset > 0 && Character.isWhitespace(string.charAt(caretOffset - 1)) && caretOffset < string.length() && Character.isWhitespace(string.charAt(caretOffset)) && !this.isInsideCommentOrString(string, caretOffset)) {
            List positions = JavaFormatter.variablesToPositions(variables);
            InsertEdit insert = new InsertEdit(caretOffset, MARKER);
            string = JavaFormatter.edit(string, positions, (TextEdit)insert);
            JavaFormatter.positionsToVariables(positions, variables);
            templateBuffer.setContent(string, variables);
            this.plainFormat(templateBuffer, context);
            string = templateBuffer.getString();
            variables = templateBuffer.getVariables();
            caretOffset = JavaFormatter.getCaretOffset(variables);
            positions = JavaFormatter.variablesToPositions(variables);
            DeleteEdit delete = new DeleteEdit(caretOffset, MARKER.length());
            string = JavaFormatter.edit(string, positions, (TextEdit)delete);
            JavaFormatter.positionsToVariables(positions, variables);
            templateBuffer.setContent(string, variables);
        } else {
            this.plainFormat(templateBuffer, context);
        }
    }

    private void plainFormat(TemplateBuffer templateBuffer, JavaContext context) throws BadLocationException {
        MultiTextEdit root;
        Document doc = new Document(templateBuffer.getString());
        TemplateVariable[] variables = templateBuffer.getVariables();
        List offsets = JavaFormatter.variablesToPositions(variables);
        Map options = context.getCompilationUnit() != null ? context.getCompilationUnit().getJavaProject().getOptions(true) : JavaCore.getOptions();
        TextEdit edit = CodeFormatterUtil.format2(0, doc.get(), this.fInitialIndentLevel, this.fLineDelimiter, options);
        if (edit == null) {
            throw new BadLocationException();
        }
        if (edit instanceof MultiTextEdit) {
            root = (MultiTextEdit)edit;
        } else {
            root = new MultiTextEdit(0, doc.getLength());
            root.addChild(edit);
        }
        Iterator it = offsets.iterator();
        while (it.hasNext()) {
            TextEdit position = (TextEdit)it.next();
            try {
                root.addChild(position);
            }
            catch (MalformedTreeException e) {}
        }
        root.apply((IDocument)doc, 2);
        JavaFormatter.positionsToVariables(offsets, variables);
        templateBuffer.setContent(doc.get(), variables);
    }

    private void indent(TemplateBuffer templateBuffer) throws BadLocationException, MalformedTreeException {
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = JavaFormatter.variablesToPositions(variables);
        Document document = new Document(templateBuffer.getString());
        MultiTextEdit root = new MultiTextEdit(0, document.getLength());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        int offset = document.getLineOffset(0);
        InsertEdit edit = new InsertEdit(offset, CodeFormatterUtil.createIndentString(this.fInitialIndentLevel));
        root.addChild((TextEdit)edit);
        root.apply((IDocument)document, 2);
        root.removeChild((TextEdit)edit);
        this.formatDelimiter((IDocument)document, root, 0);
        int lineCount = document.getNumberOfLines();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner((IDocument)document);
        JavaIndenter indenter = new JavaIndenter((IDocument)document, scanner);
        for (int line = 1; line < lineCount; ++line) {
            int nonWS;
            IRegion region = document.getLineInformation(line);
            offset = region.getOffset();
            StringBuffer indent = indenter.computeIndentation(offset);
            if (indent == null || (nonWS = scanner.findNonWhitespaceForwardInAnyPartition(offset, offset + region.getLength())) == -1) continue;
            edit = new ReplaceEdit(offset, nonWS - offset, indent.toString());
            root.addChild((TextEdit)edit);
            root.apply((IDocument)document, 2);
            root.removeChild((TextEdit)edit);
            this.formatDelimiter((IDocument)document, root, line);
        }
        JavaFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(document.get(), variables);
    }

    private void formatDelimiter(IDocument document, MultiTextEdit root, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        String lineDelimiter = document.getLineDelimiter(line);
        if (lineDelimiter != null) {
            ReplaceEdit edit = new ReplaceEdit(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            root.addChild((TextEdit)edit);
            root.apply(document, 2);
            root.removeChild((TextEdit)edit);
        }
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws BadLocationException {
        int i;
        String string = templateBuffer.getString();
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = JavaFormatter.variablesToPositions(variables);
        for (i = 0; i != string.length() && Character.isWhitespace(string.charAt(i)); ++i) {
        }
        string = JavaFormatter.edit(string, positions, (TextEdit)new DeleteEdit(0, i));
        JavaFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static String edit(String string, List positions, TextEdit edit) throws BadLocationException {
        MultiTextEdit root = new MultiTextEdit(0, string.length());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        root.addChild(edit);
        Document document = new Document(string);
        root.apply((IDocument)document);
        return document.get();
    }

    private static List variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        for (int i = 0; i != variables.length; ++i) {
            int wsStart;
            int[] offsets = variables[i].getOffsets();
            String value = variables[i].getDefaultValue();
            for (wsStart = 0; wsStart < value.length() && Character.isWhitespace(value.charAt(wsStart)) && !Strings.isLineDelimiterChar(value.charAt(wsStart)); ++wsStart) {
            }
            variables[i].getValues()[0] = value.substring(wsStart);
            for (int j = 0; j != offsets.length; ++j) {
                int n = j;
                offsets[n] = offsets[n] + wsStart;
                positions.add(new RangeMarker(offsets[j], 0));
            }
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplateVariable[] variables) {
        Iterator iterator = positions.iterator();
        for (int i = 0; i != variables.length; ++i) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            for (int j = 0; j != offsets.length; ++j) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
            }
            variable.setOffsets(offsets);
        }
    }
}

