/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JavaSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    private SmartBackspaceManager fBackspaceManager;

    public JavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setPreferenceStore(store);
    }

    public IFormattingContext createFormattingContext() {
        CommentFormattingContext context = new CommentFormattingContext();
        Hashtable map = new Hashtable(JavaCore.getOptions());
        context.storeToMap(PreferenceConstants.getPreferenceStore(), map, false);
        context.setProperty("formatting.context.preferences", map);
        return context;
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                this.fOutlinePresenter.showInformation();
                return;
            }
            case 52: {
                this.fStructurePresenter.showInformation();
                return;
            }
            case 53: {
                this.fHierarchyPresenter.showInformation();
                return;
            }
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 51) {
            return this.fOutlinePresenter != null;
        }
        if (operation == 52) {
            return this.fStructurePresenter != null;
        }
        if (operation == 53) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (configuration instanceof JavaSourceViewerConfiguration) {
            this.fOutlinePresenter = ((JavaSourceViewerConfiguration)configuration).getOutlinePresenter((ISourceViewer)this, false);
            this.fOutlinePresenter.install((ITextViewer)this);
        }
        if (configuration instanceof JavaSourceViewerConfiguration) {
            this.fStructurePresenter = ((JavaSourceViewerConfiguration)configuration).getOutlinePresenter((ISourceViewer)this, true);
            this.fStructurePresenter.install((ITextViewer)this);
        }
        if (configuration instanceof JavaSourceViewerConfiguration) {
            this.fHierarchyPresenter = ((JavaSourceViewerConfiguration)configuration).getHierarchyPresenter((ISourceViewer)this, true);
            this.fHierarchyPresenter.install((ITextViewer)this);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
                this.initializeViewerColors();
            }
        }
        this.fIsConfigured = true;
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public Point rememberSelection() {
        return super.rememberSelection();
    }

    public void restoreSelection() {
        super.restoreSelection();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = store;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.fBackspaceManager = new SmartBackspaceManager();
        this.fBackspaceManager.install((ITextViewer)this);
    }

    public SmartBackspaceManager getBackspaceManager() {
        return this.fBackspaceManager;
    }

    protected void handleDispose() {
        if (this.fBackspaceManager != null) {
            this.fBackspaceManager.uninstall();
            this.fBackspaceManager = null;
        }
        super.handleDispose();
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }

    void setReconciler(IReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    Object getReconciler() {
        return this.fReconciler;
    }
}

