/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.mbeans.MBeanUtils;

public class ServerLifecycleListener
implements ContainerListener,
LifecycleListener,
PropertyChangeListener {
    protected int debug = 0;
    boolean jsr77Names = false;
    protected String descriptors = null;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setJsr77Names(boolean b) {
        MBeanUtils.jsr77Names = b;
        this.jsr77Names = b;
    }

    public boolean getJsr77Names() {
        return this.jsr77Names;
    }

    public String getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(String descriptors) {
        this.descriptors = descriptors;
    }

    public void containerEvent(ContainerEvent event) {
        try {
            String type = event.getType();
            if ("addChild".equals(type)) {
                this.processContainerAddChild(event.getContainer(), (Container)event.getData());
            } else if ("addValve".equals(type)) {
                this.processContainerAddValve(event.getContainer(), (Valve)event.getData());
            } else if ("removeChild".equals(type)) {
                this.processContainerRemoveChild(event.getContainer(), (Container)event.getData());
            } else if ("removeValve".equals(type)) {
                this.processContainerRemoveValve(event.getContainer(), (Valve)event.getData());
            }
        }
        catch (Exception e) {
            this.log("Exception processing event " + event, e);
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context;
        Lifecycle lifecycle = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (lifecycle instanceof Server) {
                this.loadMBeanDescriptors();
                this.createMBeans();
            }
            if (lifecycle instanceof Service) {
                if (this.debug > 0) {
                    this.log("Starting embeded" + lifecycle);
                }
                try {
                    MBeanFactory factory = new MBeanFactory();
                    this.createMBeans(factory);
                    this.loadMBeanDescriptors();
                    this.createMBeans((Service)((Object)lifecycle));
                }
                catch (Exception ex) {
                    this.log("Error registering the service", ex);
                }
            }
        } else if ("stop".equals(event.getType())) {
            if (lifecycle instanceof Server) {
                this.destroyMBeans();
            }
        } else if ("reload".equals(event.getType()) && lifecycle instanceof StandardContext && (context = (StandardContext)lifecycle).getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", (Object)MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", (Object)MBeanUtils.createServer());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Container) {
            try {
                this.processContainerPropertyChange((Container)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                this.log("Exception handling Container property change", e);
            }
        } else if (event.getSource() instanceof DefaultContext) {
            try {
                this.processDefaultContextPropertyChange((DefaultContext)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                this.log("Exception handling DefaultContext property change", e);
            }
        } else if (event.getSource() instanceof NamingResources) {
            try {
                this.processNamingResourcesPropertyChange((NamingResources)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                this.log("Exception handling NamingResources property change", e);
            }
        } else if (event.getSource() instanceof Server) {
            try {
                this.processServerPropertyChange((Server)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                this.log("Exception handing Server property change", e);
            }
        } else if (event.getSource() instanceof Service) {
            try {
                this.processServicePropertyChange((Service)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                this.log("Exception handing Service property change", e);
            }
        }
    }

    protected void loadMBeanDescriptors() {
        if (this.descriptors != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.descriptors, ";");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken();
                MBeanUtils.loadMBeanDescriptors(resource);
            }
        }
    }

    protected void createMBeans() {
        try {
            MBeanFactory factory = new MBeanFactory();
            this.createMBeans(factory);
            this.createMBeans(ServerFactory.getServer());
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            this.log("createMBeans: MBeanException", e);
        }
        catch (Throwable t) {
            this.log("createMBeans: Throwable", t);
        }
    }

    protected void createMBeans(Connector connector) throws Exception {
        if (this.debug >= 5) {
            this.log("Creating MBean for Connector " + connector);
        }
        MBeanUtils.createMBean(connector);
    }

    protected void createMBeans(Context context) throws Exception {
        Manager cManager;
        Loader cLoader;
        if (this.debug >= 4) {
            this.log("Creating MBean for Context " + context);
        }
        MBeanUtils.createMBean(context);
        context.addContainerListener(this);
        if (context instanceof StandardContext) {
            ((StandardContext)context).addPropertyChangeListener(this);
            ((StandardContext)context).addLifecycleListener(this);
        }
        if (context.getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", (Object)MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", (Object)MBeanUtils.createServer());
        }
        if ((cLoader = context.getLoader()) != null) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Loader " + cLoader);
            }
            MBeanUtils.createMBean(cLoader);
        }
        Logger hLogger = context.getParent().getLogger();
        Logger cLogger = context.getLogger();
        if (cLogger != null && cLogger != hLogger) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Logger " + cLogger);
            }
            MBeanUtils.createMBean(cLogger);
        }
        if ((cManager = context.getManager()) != null) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Manager " + cManager);
            }
            MBeanUtils.createMBean(cManager);
        }
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Realm " + cRealm);
            }
            MBeanUtils.createMBean(cRealm);
        }
        if (this.jsr77Names) {
            Container[] childs = context.findChildren();
            for (int i = 0; i < childs.length; ++i) {
                StandardWrapper wrapper = (StandardWrapper)childs[i];
                if (this.debug > 0) {
                    this.log("Register child wrapper (findChildren)" + wrapper);
                }
                MBeanUtils.createMBean(wrapper);
            }
        }
        if (context instanceof StandardContext) {
            Valve[] cValves = ((StandardContext)context).getValves();
            for (int l = 0; l < cValves.length; ++l) {
                if (this.debug >= 4) {
                    this.log("Creating MBean for Valve " + cValves[l]);
                }
                MBeanUtils.createMBean(cValves[l]);
            }
        }
        NamingResources resources = context.getNamingResources();
        this.createMBeans(resources);
    }

    protected void createMBeans(ContextEnvironment environment) throws Exception {
        if (this.debug >= 3) {
            this.log("Creating MBean for ContextEnvironment " + environment);
        }
        MBeanUtils.createMBean(environment);
    }

    protected void createMBeans(Wrapper wrapper) throws Exception {
        if (!this.jsr77Names) {
            return;
        }
        if (this.debug >= 3) {
            this.log("Creating MBean for Wrapper " + wrapper);
        }
        MBeanUtils.createMBean(wrapper);
    }

    protected void createMBeans(ContextResource resource) throws Exception {
        if (this.debug >= 3) {
            this.log("Creating MBean for ContextResource " + resource);
        }
        MBeanUtils.createMBean(resource);
    }

    protected void createMBeans(ContextResourceLink resourceLink) throws Exception {
        if (this.debug >= 3) {
            this.log("Creating MBean for ContextResourceLink " + resourceLink);
        }
        MBeanUtils.createMBean(resourceLink);
    }

    protected void createMBeans(DefaultContext dcontext) throws Exception {
        Manager dManager;
        if (this.debug >= 4) {
            this.log("Creating MBean for DefaultContext " + dcontext);
        }
        MBeanUtils.createMBean(dcontext);
        dcontext.addPropertyChangeListener(this);
        Loader dLoader = dcontext.getLoader();
        if (dLoader != null) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Loader " + dLoader);
            }
            MBeanUtils.createMBean(dLoader);
        }
        if ((dManager = dcontext.getManager()) != null) {
            if (this.debug >= 4) {
                this.log("Creating MBean for Manager " + dManager);
            }
            MBeanUtils.createMBean(dManager);
        }
        NamingResources resources = dcontext.getNamingResources();
        this.createMBeans(resources);
    }

    protected void createMBeans(Engine engine) throws Exception {
        int j;
        Realm eRealm;
        Logger eLogger;
        if (this.debug >= 2) {
            this.log("Creating MBean for Engine " + engine);
        }
        MBeanUtils.createMBean(engine);
        engine.addContainerListener(this);
        if (engine instanceof StandardEngine) {
            ((StandardEngine)engine).addPropertyChangeListener(this);
        }
        if ((eLogger = engine.getLogger()) != null) {
            if (this.debug >= 2) {
                this.log("Creating MBean for Logger " + eLogger);
            }
            try {
                MBeanUtils.createMBean(eLogger);
            }
            catch (Exception ex) {
                this.log("Can't create mbean for logger " + eLogger);
            }
        }
        if ((eRealm = engine.getRealm()) != null) {
            if (this.debug >= 2) {
                this.log("Creating MBean for Realm " + eRealm);
            }
            try {
                MBeanUtils.createMBean(eRealm);
            }
            catch (Exception ex) {
                this.log("Can't create mbean for realm " + eRealm);
            }
        }
        if (engine instanceof StandardEngine) {
            Valve[] eValves = ((StandardEngine)engine).getValves();
            for (j = 0; j < eValves.length; ++j) {
                if (this.debug >= 2) {
                    this.log("Creating MBean for Valve " + eValves[j]);
                }
                try {
                    MBeanUtils.createMBean(eValves[j]);
                    continue;
                }
                catch (Exception ex) {
                    this.log("Can't create mbean for valve " + eRealm);
                }
            }
        }
        Container[] hosts = engine.findChildren();
        for (j = 0; j < hosts.length; ++j) {
            this.createMBeans((Host)hosts[j]);
        }
        DefaultContext dcontext = engine.getDefaultContext();
        if (dcontext != null) {
            dcontext.setParent(engine);
            this.createMBeans(dcontext);
        }
    }

    protected void createMBeans(Host host) throws Exception {
        int k;
        if (this.debug >= 3) {
            this.log("Creating MBean for Host " + host);
        }
        MBeanUtils.createMBean(host);
        host.addContainerListener(this);
        if (host instanceof StandardHost) {
            ((StandardHost)host).addPropertyChangeListener(this);
        }
        Logger eLogger = host.getParent().getLogger();
        Logger hLogger = host.getLogger();
        if (hLogger != null && hLogger != eLogger) {
            if (this.debug >= 3) {
                this.log("Creating MBean for Logger " + hLogger);
            }
            MBeanUtils.createMBean(hLogger);
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm) {
            if (this.debug >= 3) {
                this.log("Creating MBean for Realm " + hRealm);
            }
            MBeanUtils.createMBean(hRealm);
        }
        if (host instanceof StandardHost) {
            Valve[] hValves = ((StandardHost)host).getValves();
            for (k = 0; k < hValves.length; ++k) {
                if (this.debug >= 3) {
                    this.log("Creating MBean for Valve " + hValves[k]);
                }
                MBeanUtils.createMBean(hValves[k]);
            }
        }
        Container[] contexts = host.findChildren();
        for (k = 0; k < contexts.length; ++k) {
            this.createMBeans((Context)contexts[k]);
        }
        DefaultContext dcontext = host.getDefaultContext();
        if (dcontext != null) {
            dcontext.setParent(host);
            this.createMBeans(dcontext);
        }
    }

    protected void createMBeans(MBeanFactory factory) throws Exception {
        if (this.debug >= 2) {
            this.log("Creating MBean for MBeanFactory " + (Object)((Object)factory));
        }
        MBeanUtils.createMBean(factory);
    }

    protected void createMBeans(NamingResources resources) throws Exception {
        if (this.debug >= 2) {
            this.log("Creating MBean for NamingResources " + resources);
        }
        MBeanUtils.createMBean(resources);
        resources.addPropertyChangeListener(this);
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.createMBeans(environments[i]);
        }
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.createMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.createMBeans(cresourcelinks[i]);
        }
    }

    protected void createMBeans(Server server) throws Exception {
        NamingResources resources;
        if (this.debug >= 2) {
            this.log("Creating MBean for Server " + server);
        }
        MBeanUtils.createMBean(server);
        if (server instanceof StandardServer) {
            ((StandardServer)server).addPropertyChangeListener(this);
        }
        if ((resources = server.getGlobalNamingResources()) != null) {
            this.createMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            if (services[i].getContainer().getClass().getName().equals("org.apache.catalina.connector.warp.WarpEngine")) {
                if (this.debug < 1) continue;
                this.log("Skipping MBean for Service " + services[i]);
                continue;
            }
            this.createMBeans(services[i]);
        }
    }

    protected void createMBeans(Service service) throws Exception {
        if (this.debug >= 2) {
            this.log("Creating MBean for Service " + service);
        }
        MBeanUtils.createMBean(service);
        if (service instanceof StandardService) {
            ((StandardService)service).addPropertyChangeListener(this);
        }
        Connector[] connectors = service.findConnectors();
        for (int j = 0; j < connectors.length; ++j) {
            this.createMBeans(connectors[j]);
        }
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            this.createMBeans(engine);
        }
    }

    protected void destroyMBeans() {
        try {
            this.destroyMBeans(ServerFactory.getServer());
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            this.log("destroyMBeans: MBeanException", e);
        }
        catch (Throwable t) {
            this.log("destroyMBeans: Throwable", t);
        }
    }

    protected void destroyMBeans(Connector connector, Service service) throws Exception {
        if (this.debug >= 5) {
            this.log("Destroying MBean for Connector " + connector);
        }
        MBeanUtils.destroyMBean(connector, service);
    }

    protected void destroyMBeans(Context context) throws Exception {
        NamingResources resources;
        Loader cLoader;
        Manager cManager;
        context.removeContainerListener(this);
        if (context instanceof StandardContext) {
            Valve[] cValves = ((StandardContext)context).getValves();
            for (int l = 0; l < cValves.length; ++l) {
                if (this.debug >= 4) {
                    this.log("Destroying MBean for Valve " + cValves[l]);
                }
                MBeanUtils.destroyMBean(cValves[l], context);
            }
        }
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Realm " + cRealm);
            }
            MBeanUtils.destroyMBean(cRealm);
        }
        if ((cManager = context.getManager()) != null) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Manager " + cManager);
            }
            MBeanUtils.destroyMBean(cManager);
        }
        Logger hLogger = context.getParent().getLogger();
        Logger cLogger = context.getLogger();
        if (cLogger != null && cLogger != hLogger) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Logger " + cLogger);
            }
            MBeanUtils.destroyMBean(cLogger);
        }
        if ((cLoader = context.getLoader()) != null) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Loader " + cLoader);
            }
            MBeanUtils.destroyMBean(cLoader);
        }
        if ((resources = context.getNamingResources()) != null) {
            this.destroyMBeans(resources);
        }
        if (this.debug >= 4) {
            this.log("Destroying MBean for Context " + context);
        }
        MBeanUtils.destroyMBean(context);
        if (context instanceof StandardContext) {
            ((StandardContext)context).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(Wrapper wrapper) throws Exception {
        if (!this.jsr77Names) {
            return;
        }
        if (this.debug >= 3) {
            this.log("Destroying MBean for Wrapper " + wrapper);
        }
        MBeanUtils.destroyMBean(wrapper);
    }

    protected void destroyMBeans(ContextEnvironment environment) throws Exception {
        if (this.debug >= 3) {
            this.log("Destroying MBean for ContextEnvironment " + environment);
        }
        MBeanUtils.destroyMBean(environment);
    }

    protected void destroyMBeans(ContextResource resource) throws Exception {
        if (this.debug >= 3) {
            this.log("Destroying MBean for ContextResource " + resource);
        }
        MBeanUtils.destroyMBean(resource);
    }

    protected void destroyMBeans(ContextResourceLink resourceLink) throws Exception {
        if (this.debug >= 3) {
            this.log("Destroying MBean for ContextResourceLink " + resourceLink);
        }
        MBeanUtils.destroyMBean(resourceLink);
    }

    protected void destroyMBeans(DefaultContext dcontext) throws Exception {
        NamingResources resources;
        Loader dLoader;
        Manager dManager = dcontext.getManager();
        if (dManager != null) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Manager " + dManager);
            }
            MBeanUtils.destroyMBean(dManager);
        }
        if ((dLoader = dcontext.getLoader()) != null) {
            if (this.debug >= 4) {
                this.log("Destroying MBean for Loader " + dLoader);
            }
            MBeanUtils.destroyMBean(dLoader);
        }
        if ((resources = dcontext.getNamingResources()) != null) {
            this.destroyMBeans(resources);
        }
        if (this.debug >= 4) {
            this.log("Destroying MBean for Context " + dcontext);
        }
        MBeanUtils.destroyMBean(dcontext);
        dcontext.removePropertyChangeListener(this);
    }

    protected void destroyMBeans(Engine engine) throws Exception {
        Logger eLogger;
        Realm eRealm;
        engine.removeContainerListener(this);
        Container[] hosts = engine.findChildren();
        for (int k = 0; k < hosts.length; ++k) {
            this.destroyMBeans((Host)hosts[k]);
        }
        if (engine instanceof StandardEngine) {
            Valve[] eValves = ((StandardEngine)engine).getValves();
            for (int k = 0; k < eValves.length; ++k) {
                if (this.debug >= 3) {
                    this.log("Destroying MBean for Valve " + eValves[k]);
                }
                MBeanUtils.destroyMBean(eValves[k], engine);
            }
        }
        if ((eRealm = engine.getRealm()) != null) {
            if (this.debug >= 3) {
                this.log("Destroying MBean for Realm " + eRealm);
            }
            MBeanUtils.destroyMBean(eRealm);
        }
        if ((eLogger = engine.getLogger()) != null) {
            if (this.debug >= 3) {
                this.log("Destroying MBean for Logger " + eLogger);
            }
            MBeanUtils.destroyMBean(eLogger);
        }
        if (this.debug >= 2) {
            this.log("Destroying MBean for Engine " + engine);
        }
        MBeanUtils.destroyMBean(engine);
    }

    protected void destroyMBeans(Host host) throws Exception {
        host.removeContainerListener(this);
        Container[] contexts = host.findChildren();
        for (int k = 0; k < contexts.length; ++k) {
            this.destroyMBeans((Context)contexts[k]);
        }
        if (host instanceof StandardHost) {
            Valve[] hValves = ((StandardHost)host).getValves();
            for (int k = 0; k < hValves.length; ++k) {
                if (this.debug >= 3) {
                    this.log("Destroying MBean for Valve " + hValves[k]);
                }
                MBeanUtils.destroyMBean(hValves[k], host);
            }
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm) {
            if (this.debug >= 3) {
                this.log("Destroying MBean for Realm " + hRealm);
            }
            MBeanUtils.destroyMBean(hRealm);
        }
        Logger eLogger = host.getParent().getLogger();
        Logger hLogger = host.getLogger();
        if (hLogger != null && hLogger != eLogger) {
            if (this.debug >= 3) {
                this.log("Destroying MBean for Logger " + hLogger);
            }
            MBeanUtils.destroyMBean(hLogger);
        }
        if (this.debug >= 3) {
            this.log("Destroying MBean for Host " + host);
        }
        MBeanUtils.destroyMBean(host);
    }

    protected void destroyMBeans(NamingResources resources) throws Exception {
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.destroyMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.destroyMBeans(cresourcelinks[i]);
        }
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.destroyMBeans(environments[i]);
        }
        if (this.debug >= 2) {
            this.log("Destroying MBean for NamingResources " + resources);
        }
        MBeanUtils.destroyMBean(resources);
        resources.removePropertyChangeListener(this);
    }

    protected void destroyMBeans(Server server) throws Exception {
        NamingResources resources = server.getGlobalNamingResources();
        if (resources != null) {
            this.destroyMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            if (services[i].getContainer().getClass().getName().equals("org.apache.catalina.connector.warp.WarpEngine")) {
                if (this.debug < 1) continue;
                this.log("Skipping MBean for Service " + services[i]);
                continue;
            }
            this.destroyMBeans(services[i]);
        }
        if (this.debug >= 2) {
            this.log("Destroying MBean for Server " + server);
        }
        MBeanUtils.destroyMBean(server);
        if (server instanceof StandardServer) {
            ((StandardServer)server).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(Service service) throws Exception {
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            this.destroyMBeans(engine);
        }
        Connector[] connectors = service.findConnectors();
        for (int j = 0; j < connectors.length; ++j) {
            this.destroyMBeans(connectors[j], service);
        }
        if (this.debug >= 2) {
            this.log("Destroying MBean for Service " + service);
        }
        MBeanUtils.destroyMBean(service);
        if (service instanceof StandardService) {
            ((StandardService)service).removePropertyChangeListener(this);
        }
    }

    protected void log(String message) {
        System.out.print("ServerLifecycleListener: ");
        System.out.println(message);
    }

    protected void log(String message, Throwable throwable) {
        this.log(message);
        throwable.printStackTrace(System.out);
    }

    protected void processContainerAddChild(Container parent, Container child) {
        if (this.debug >= 1) {
            this.log("Process addChild[parent=" + parent + ",child=" + child + "]");
        }
        try {
            if (child instanceof Context) {
                this.createMBeans((Context)child);
            } else if (child instanceof Engine) {
                this.createMBeans((Engine)child);
            } else if (child instanceof Host) {
                this.createMBeans((Host)child);
            } else if (child instanceof Wrapper) {
                if (this.debug > 0) {
                    this.log("addChild callback for wrapper " + child);
                }
                if (this.jsr77Names) {
                    this.createMBeans((Wrapper)child);
                }
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            this.log("processContainerAddChild: MBeanException", e);
        }
        catch (Throwable t) {
            this.log("processContainerAddChild: Throwable", t);
        }
    }

    protected void processContainerAddValve(Container container, Valve valve) throws Exception {
        if (this.debug >= 1) {
            this.log("Process addValve[container=" + container + ",valve=" + valve + "]");
        }
        if (this.debug >= 4) {
            this.log("Creating MBean for Valve " + valve);
        }
        MBeanUtils.createMBean(valve);
    }

    protected void processContainerPropertyChange(Container container, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (this.debug >= 6) {
            this.log("propertyChange[container=" + container + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("defaultContext".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for DefaultContext " + oldValue);
                }
                this.destroyMBeans((DefaultContext)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for DefaultContext " + newValue);
                }
                this.createMBeans((DefaultContext)newValue);
            }
        } else if ("loader".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Loader " + oldValue);
                }
                MBeanUtils.destroyMBean((Loader)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Loader " + newValue);
                }
                MBeanUtils.createMBean((Loader)newValue);
            }
        } else if ("logger".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Logger " + oldValue);
                }
                MBeanUtils.destroyMBean((Logger)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Logger " + newValue);
                }
                MBeanUtils.createMBean((Logger)newValue);
            }
        } else if ("manager".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Manager " + oldValue);
                }
                MBeanUtils.destroyMBean((Manager)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Manager " + newValue);
                }
                MBeanUtils.createMBean((Manager)newValue);
            }
        } else if ("realm".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Realm " + oldValue);
                }
                MBeanUtils.destroyMBean((Realm)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Realm " + newValue);
                }
                MBeanUtils.createMBean((Realm)newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processDefaultContextPropertyChange(DefaultContext defaultContext, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (this.debug >= 6) {
            this.log("propertyChange[defaultContext=" + defaultContext + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("loader".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Loader " + oldValue);
                }
                MBeanUtils.destroyMBean((Loader)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Loader " + newValue);
                }
                MBeanUtils.createMBean((Loader)newValue);
            }
        } else if ("logger".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Logger " + oldValue);
                }
                MBeanUtils.destroyMBean((Logger)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Logger " + newValue);
                }
                MBeanUtils.createMBean((Logger)newValue);
            }
        } else if ("manager".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Manager " + oldValue);
                }
                MBeanUtils.destroyMBean((Manager)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Manager " + newValue);
                }
                MBeanUtils.createMBean((Manager)newValue);
            }
        } else if ("realm".equals(propertyName)) {
            if (oldValue != null) {
                if (this.debug >= 5) {
                    this.log("Removing MBean for Realm " + oldValue);
                }
                MBeanUtils.destroyMBean((Realm)oldValue);
            }
            if (newValue != null) {
                if (this.debug >= 5) {
                    this.log("Creating MBean for Realm " + newValue);
                }
                MBeanUtils.createMBean((Realm)newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processContainerRemoveChild(Container parent, Container child) {
        if (this.debug >= 1) {
            this.log("Process removeChild[parent=" + parent + ",child=" + child + "]");
        }
        try {
            if (child instanceof Context) {
                Context context = (Context)child;
                if (context.getPrivileged()) {
                    context.getServletContext().removeAttribute("org.apache.catalina.Registry");
                    context.getServletContext().removeAttribute("org.apache.catalina.MBeanServer");
                }
                if (this.debug >= 4) {
                    this.log("  Removing MBean for Context " + context);
                }
                this.destroyMBeans(context);
                if (context instanceof StandardContext) {
                    ((StandardContext)context).removePropertyChangeListener(this);
                }
            } else if (child instanceof Host) {
                Host host = (Host)child;
                this.destroyMBeans(host);
                if (host instanceof StandardHost) {
                    ((StandardHost)host).removePropertyChangeListener(this);
                }
            } else if (child instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)child;
                if (this.jsr77Names) {
                    this.destroyMBeans(wrapper);
                }
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            this.log("processContainerRemoveChild: MBeanException", e);
        }
        catch (Throwable t) {
            this.log("processContainerRemoveChild: Throwable", t);
        }
    }

    protected void processContainerRemoveValve(Container container, Valve valve) {
        if (this.debug >= 1) {
            this.log("Process removeValve[container=" + container + ",valve=" + valve + "]");
        }
        try {
            MBeanUtils.destroyMBean(valve, container);
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            this.log("processContainerRemoveValve: MBeanException", e);
        }
        catch (Throwable t) {
            this.log("processContainerRemoveValve: Throwable", t);
        }
    }

    protected void processNamingResourcesPropertyChange(NamingResources resources, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (this.debug >= 6) {
            this.log("propertyChange[namingResources=" + resources + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("environment".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextEnvironment)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextEnvironment)newValue);
            }
        } else if ("resource".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResource)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResource)newValue);
            }
        } else if ("resourceLink".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResourceLink)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResourceLink)newValue);
            }
        }
    }

    protected void processServerPropertyChange(Server server, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (this.debug >= 6) {
            this.log("propertyChange[server=" + server + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("globalNamingResources".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((NamingResources)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((NamingResources)newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processServicePropertyChange(Service service, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (this.debug >= 6) {
            this.log("propertyChange[service=" + service + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("connector".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Connector)oldValue, service);
            }
            if (newValue != null) {
                this.createMBeans((Connector)newValue);
            }
        } else if ("container".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Engine)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Engine)newValue);
            }
        }
    }
}

