/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.Vector;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.jdt.internal.junit.runner.JUnitMessages;

public class RemoteTestRunner
implements TestListener {
    private static final String SET_UP_TEST_METHOD_NAME = "setUpTest";
    private static final String SUITE_METHODNAME = "suite";
    private String[] fTestClassNames;
    private String fTestName;
    private TestResult fTestResult;
    private String fVersion = "";
    private Socket fClientSocket;
    private PrintWriter fWriter;
    private BufferedReader fReader;
    private String fHost = "";
    private int fPort = -1;
    private boolean fDebugMode = false;
    private boolean fKeepAlive = false;
    private boolean fStopped = false;
    private Vector fRerunRequests = new Vector(10);
    private ReaderThread fReaderThread;
    private String fRerunTest;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) {
        RemoteTestRunner testRunServer = new RemoteTestRunner();
        testRunServer.init(args);
        testRunServer.run();
        System.exit(0);
    }

    protected void init(String[] args) {
        this.defaultInit(args);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected final void defaultInit(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().equals("-classnames") || args[i].toLowerCase().equals("-classname")) {
                Vector<String> list = new Vector<String>();
                for (int j = i + 1; j < args.length && !args[j].startsWith("-"); ++j) {
                    list.add(args[j]);
                }
                this.fTestClassNames = list.toArray(new String[list.size()]);
                continue;
            }
            if (args[i].toLowerCase().equals("-test")) {
                String testName = args[i + 1];
                int p = testName.indexOf(58);
                if (p == -1) {
                    throw new IllegalArgumentException("Testname not separated by '%'");
                }
                this.fTestName = testName.substring(p + 1);
                this.fTestClassNames = new String[]{testName.substring(0, p)};
                ++i;
                continue;
            }
            if (args[i].toLowerCase().equals("-testnamefile")) {
                String testNameFile = args[i + 1];
                try {
                    this.readTestNames(testNameFile);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot read testname file.");
                }
                ++i;
                continue;
            }
            if (args[i].toLowerCase().equals("-port")) {
                this.fPort = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].toLowerCase().equals("-host")) {
                this.fHost = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].toLowerCase().equals("-rerun")) {
                this.fRerunTest = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].toLowerCase().equals("-keepalive")) {
                this.fKeepAlive = true;
                continue;
            }
            if (args[i].toLowerCase().equals("-debugging") || args[i].toLowerCase().equals("-debug")) {
                this.fDebugMode = true;
                continue;
            }
            if (!args[i].toLowerCase().equals("-version")) continue;
            this.fVersion = args[i + 1];
            ++i;
        }
        if (this.fTestClassNames == null || this.fTestClassNames.length == 0) {
            throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.classnamemissing"));
        }
        if (this.fPort == -1) {
            throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.portmissing"));
        }
        if (this.fDebugMode) {
            System.out.println("keepalive " + this.fKeepAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTestNames(String testNameFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(new File(testNameFile)));
        try {
            String line;
            Vector<String> list = new Vector<String>();
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            this.fTestClassNames = list.toArray(new String[list.size()]);
        }
        finally {
            br.close();
        }
        if (this.fDebugMode) {
            System.out.println("Tests:");
            for (int i = 0; i < this.fTestClassNames.length; ++i) {
                System.out.println("    " + this.fTestClassNames[i]);
            }
        }
    }

    protected void run() {
        if (!this.connect()) {
            return;
        }
        if (this.fRerunTest != null) {
            this.rerunTest(Integer.parseInt(this.fRerunTest), this.fTestClassNames[0], this.fTestName);
            return;
        }
        this.fTestResult = new TestResult();
        this.fTestResult.addListener((TestListener)this);
        this.runTests(this.fTestClassNames, this.fTestName);
        this.fTestResult.removeListener((TestListener)this);
        if (this.fTestResult != null) {
            this.fTestResult.stop();
            this.fTestResult = null;
        }
        if (this.fKeepAlive) {
            this.waitForReruns();
        }
        this.shutDown();
    }

    private synchronized void waitForReruns() {
        while (!this.fStopped) {
            try {
                this.wait();
                if (this.fStopped || this.fRerunRequests.size() <= 0) continue;
                RerunRequest r = (RerunRequest)this.fRerunRequests.remove(0);
                this.rerunTest(r.fRerunTestId, r.fRerunClassName, r.fRerunTestName);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Test getTest(String suiteClassName, String testName) {
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.classnotfound", clazz));
            return null;
        }
        catch (Exception e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.exception", e));
            return null;
        }
        if (testName != null) {
            return this.setupTest(testClass, this.createTest(testName, testClass));
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception e) {
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.getTargetException().toString()));
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.toString()));
            return null;
        }
        return test;
    }

    protected void runFailed(String message) {
        System.err.println(message);
    }

    private Class loadSuiteClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        return this.getClassLoader().loadClass(className);
    }

    private void runTests(String[] testClassNames, String testName) {
        Test[] suites = new Test[testClassNames.length];
        for (int i = 0; i < suites.length; ++i) {
            suites[i] = this.getTest(testClassNames[i], testName);
        }
        int count = this.countTests(suites);
        this.notifyTestRunStarted(count);
        if (count == 0) {
            this.notifyTestRunEnded(0L);
            return;
        }
        long startTime = System.currentTimeMillis();
        if (this.fDebugMode) {
            System.out.print("start send tree...");
        }
        for (int i = 0; i < suites.length; ++i) {
            this.sendTree(suites[i]);
        }
        if (this.fDebugMode) {
            System.out.println("done send tree - time(ms): " + (System.currentTimeMillis() - startTime));
        }
        long testStartTime = System.currentTimeMillis();
        for (int i = 0; i < suites.length; ++i) {
            suites[i].run(this.fTestResult);
        }
        if (this.fTestResult == null || this.fTestResult.shouldStop()) {
            this.notifyTestRunStopped(System.currentTimeMillis() - testStartTime);
        } else {
            this.notifyTestRunEnded(System.currentTimeMillis() - testStartTime);
        }
    }

    private int countTests(Test[] tests) {
        int count = 0;
        for (int i = 0; i < tests.length; ++i) {
            if (tests[i] == null) continue;
            count += tests[i].countTestCases();
        }
        return count;
    }

    public void rerunTest(int testId, String className, String testName) {
        Test reloadedTest = null;
        Class<?> reloadedTestClass = null;
        try {
            reloadedTestClass = this.getClassLoader().loadClass(className);
            reloadedTest = this.createTest(testName, reloadedTestClass);
        }
        catch (Exception e) {
            reloadedTest = this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotcreate", testName));
        }
        Test rerunTest = this.setupTest(reloadedTestClass, reloadedTest);
        TestResult result = new TestResult();
        rerunTest.run(result);
        this.notifyTestReran(result, Integer.toString(testId), className, testName);
    }

    private Test setupTest(Class reloadedTestClass, Test reloadedTest) {
        Method setup = null;
        try {
            setup = reloadedTestClass.getMethod(SET_UP_TEST_METHOD_NAME, class$junit$framework$Test == null ? (class$junit$framework$Test = RemoteTestRunner.class$("junit.framework.Test")) : class$junit$framework$Test);
        }
        catch (SecurityException e1) {
            return reloadedTest;
        }
        catch (NoSuchMethodException e) {
            return reloadedTest;
        }
        if (setup.getReturnType() != (class$junit$framework$Test == null ? (class$junit$framework$Test = RemoteTestRunner.class$("junit.framework.Test")) : class$junit$framework$Test)) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.notestreturn"));
        }
        if (!Modifier.isPublic(setup.getModifiers())) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.shouldbepublic"));
        }
        if (!Modifier.isStatic(setup.getModifiers())) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.shouldbestatic"));
        }
        try {
            Test test = (Test)setup.invoke(null, reloadedTest);
            if (test == null) {
                return this.warning(JUnitMessages.getString("RemoteTestRunner.error.nullreturn"));
            }
            return test;
        }
        catch (IllegalArgumentException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (IllegalAccessException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (InvocationTargetException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.invocationexception", e.getTargetException()));
        }
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }

    private Test createTest(String testName, Class testClass) {
        Class[] classArgs = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RemoteTestRunner.class$("java.lang.String")) : class$java$lang$String};
        Constructor constructor = null;
        try {
            Test test;
            block9: {
                try {
                    constructor = testClass.getConstructor(classArgs);
                    test = (Test)constructor.newInstance(testName);
                }
                catch (NoSuchMethodException e) {
                    constructor = testClass.getConstructor(new Class[0]);
                    test = (Test)constructor.newInstance(new Object[0]);
                    if (!(test instanceof TestCase)) break block9;
                    ((TestCase)test).setName(testName);
                }
            }
            if (test != null) {
                return test;
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return this.warning("Could not create test '" + testName + "' ");
    }

    public final void addError(Test test, Throwable throwable) {
        this.notifyTestFailed(test, "%ERROR  ", this.getTrace(throwable));
    }

    public final void addFailure(Test test, AssertionFailedError assertionFailedError) {
        if ("3".equals(this.fVersion) && this.isComparisonFailure((Throwable)assertionFailedError)) {
            String expected = this.getField(assertionFailedError, "fExpected");
            String actual = this.getField(assertionFailedError, "fActual");
            if (expected != null && actual != null) {
                this.notifyTestFailed2(test, "%FAILED ", this.getTrace((Throwable)assertionFailedError), expected, actual);
                return;
            }
        }
        this.notifyTestFailed(test, "%FAILED ", this.getTrace((Throwable)assertionFailedError));
    }

    private boolean isComparisonFailure(Throwable throwable) {
        return throwable.getClass().getName().equals("junit.framework.ComparisonFailure");
    }

    public void endTest(Test test) {
        this.notifyTestEnded(test);
    }

    public void startTest(Test test) {
        this.notifyTestStarted(test);
    }

    private void sendTree(Test test) {
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            this.sendTree(decorator.getTest());
        } else if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            this.notifyTestTreeEntry(this.getTestId(test) + ',' + this.escapeComma(suite.toString().trim()) + ',' + true + ',' + suite.testCount());
            for (int i = 0; i < suite.testCount(); ++i) {
                this.sendTree(suite.testAt(i));
            }
        } else {
            this.notifyTestTreeEntry(this.getTestId(test) + ',' + this.escapeComma(this.getTestName(test).trim()) + ',' + false + ',' + test.countTestCases());
        }
    }

    private String escapeComma(String s) {
        if (s.indexOf(44) < 0 && s.indexOf(92) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ',') {
                sb.append("\\,");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String getTestId(Test test) {
        return Integer.toString(System.identityHashCode(test));
    }

    private String getTestName(Test test) {
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            return JUnitMessages.getFormattedString("RemoteTestRunner.testName", new String[]{testCase.getName(), test.getClass().getName()});
        }
        if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            if (suite.getName() != null) {
                return suite.getName();
            }
            return this.getClass().getName();
        }
        return test.toString();
    }

    private String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    protected void stop() {
        if (this.fTestResult != null) {
            this.fTestResult.stop();
        }
    }

    private boolean connect() {
        if (this.fDebugMode) {
            System.out.println("RemoteTestRunner: trying to connect" + this.fHost + ":" + this.fPort);
        }
        IOException exception = null;
        for (int i = 1; i < 20; ++i) {
            try {
                this.fClientSocket = new Socket(this.fHost, this.fPort);
                try {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream(), "UTF-8")), false);
                }
                catch (UnsupportedEncodingException e1) {
                    this.fWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.fClientSocket.getOutputStream())), false);
                }
                try {
                    this.fReader = new BufferedReader(new InputStreamReader(this.fClientSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    this.fReader = new BufferedReader(new InputStreamReader(this.fClientSocket.getInputStream()));
                }
                this.fReaderThread = new ReaderThread();
                this.fReaderThread.start();
                return true;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.connect", new String[]{this.fHost, Integer.toString(this.fPort)}));
        exception.printStackTrace();
        return false;
    }

    private void shutDown() {
        block9: {
            block8: {
                if (this.fWriter != null) {
                    this.fWriter.close();
                    this.fWriter = null;
                }
                try {
                    if (this.fReaderThread != null) {
                        this.fReaderThread.interrupt();
                    }
                    if (this.fReader != null) {
                        this.fReader.close();
                        this.fReader = null;
                    }
                }
                catch (IOException e) {
                    if (!this.fDebugMode) break block8;
                    e.printStackTrace();
                }
            }
            try {
                if (this.fClientSocket != null) {
                    this.fClientSocket.close();
                    this.fClientSocket = null;
                }
            }
            catch (IOException e) {
                if (!this.fDebugMode) break block9;
                e.printStackTrace();
            }
        }
    }

    private void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    private void notifyTestRunStarted(int testCount) {
        this.sendMessage("%TESTC  " + testCount + " " + "v2");
    }

    private void notifyTestRunEnded(long elapsedTime) {
        this.sendMessage("%RUNTIME" + elapsedTime);
        this.fWriter.flush();
    }

    private void notifyTestRunStopped(long elapsedTime) {
        this.sendMessage("%TSTSTP " + elapsedTime);
        this.fWriter.flush();
    }

    private void notifyTestStarted(Test test) {
        this.sendMessage("%TESTS  " + this.getTestId(test) + ',' + test.toString());
        this.fWriter.flush();
    }

    private void notifyTestEnded(Test test) {
        this.sendMessage("%TESTE  " + this.getTestId(test) + ',' + this.getTestName(test));
    }

    private void notifyTestFailed(Test test, String status, String trace) {
        this.sendMessage(status + this.getTestId(test) + ',' + this.getTestName(test));
        this.sendMessage("%TRACES ");
        this.sendMessage(trace);
        this.sendMessage("%TRACEE ");
        this.fWriter.flush();
    }

    private void notifyTestFailed2(Test test, String status, String trace, String expected, String actual) {
        this.sendMessage(status + this.getTestId(test) + ',' + this.getTestName(test));
        this.sendMessage("%EXPECTS");
        this.sendMessage(expected);
        this.sendMessage("%EXPECTE");
        this.sendMessage("%ACTUALS");
        this.sendMessage(actual);
        this.sendMessage("%ACTUALE");
        this.sendMessage("%TRACES ");
        this.sendMessage(trace);
        this.sendMessage("%TRACEE ");
        this.fWriter.flush();
    }

    private void notifyTestTreeEntry(String treeEntry) {
        this.sendMessage("%TSTTREE" + treeEntry);
    }

    private void notifyTestReran(TestResult result, String testId, String testClass, String testName) {
        TestFailure failure = null;
        if (result.errorCount() > 0) {
            failure = (TestFailure)result.errors().nextElement();
        }
        if (result.failureCount() > 0) {
            failure = (TestFailure)result.failures().nextElement();
        }
        if (failure != null) {
            Throwable t = failure.thrownException();
            if ("3".equals(this.fVersion) && this.isComparisonFailure(t)) {
                String expected = this.getField(t, "fExpected");
                String actual = this.getField(t, "fActual");
                if (expected != null && actual != null) {
                    this.sendMessage("%EXPECTS");
                    this.sendMessage(expected);
                    this.sendMessage("%EXPECTE");
                    this.sendMessage("%ACTUALS");
                    this.sendMessage(actual);
                    this.sendMessage("%ACTUALE");
                }
            }
            String trace = this.getTrace(t);
            this.sendMessage("%RTRACES");
            this.sendMessage(trace);
            this.sendMessage("%RTRACEE");
            this.fWriter.flush();
        }
        String status = "OK";
        if (result.errorCount() > 0) {
            status = "ERROR";
        } else if (result.failureCount() > 0) {
            status = "FAILURE";
        }
        if (this.fPort != -1) {
            this.sendMessage("%TSTRERN" + testId + " " + testClass + " " + testName + " " + status);
            this.fWriter.flush();
        }
    }

    private String getField(Object object, String fieldName) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object result = field.get(object);
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                String message = null;
                while (true) {
                    if ((message = RemoteTestRunner.this.fReader.readLine()) == null) {
                        continue;
                    }
                    if (message.startsWith(">STOP   ")) {
                        RemoteTestRunner.this.fStopped = true;
                        RemoteTestRunner.this.stop();
                        RemoteTestRunner remoteTestRunner = RemoteTestRunner.this;
                        synchronized (remoteTestRunner) {
                            RemoteTestRunner.this.notifyAll();
                            return;
                        }
                    }
                    if (!message.startsWith(">RERUN  ")) continue;
                    String arg = message.substring(8);
                    int c0 = arg.indexOf(32);
                    int c1 = arg.indexOf(32, c0 + 1);
                    String s = arg.substring(0, c0);
                    int testId = Integer.parseInt(s);
                    String className = arg.substring(c0 + 1, c1);
                    String testName = arg.substring(c1 + 1, arg.length());
                    RemoteTestRunner remoteTestRunner = RemoteTestRunner.this;
                    synchronized (remoteTestRunner) {
                        RemoteTestRunner.this.fRerunRequests.add(new RerunRequest(testId, className, testName));
                        RemoteTestRunner.this.notifyAll();
                    }
                }
            }
            catch (Exception e) {
                RemoteTestRunner.this.stop();
            }
        }
    }

    private static class RerunRequest {
        String fRerunClassName;
        String fRerunTestName;
        int fRerunTestId;

        public RerunRequest(int testId, String className, String testName) {
            this.fRerunTestId = testId;
            this.fRerunClassName = className;
            this.fRerunTestName = testName;
        }
    }
}

