/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.pde.internal.ui.parts.StatusInfo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.MessageLine;

public abstract class StatusDialog
extends Dialog {
    private Button fOkButton;
    private MessageLine fStatusLine;
    private IStatus fLastStatus = new StatusInfo();
    private String fTitle;
    private Image fImage;

    public StatusDialog(Shell parent) {
        super(parent);
    }

    protected void updateStatus(IStatus status) {
        this.fLastStatus = status;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.fStatusLine.setErrorStatus(status);
        }
    }

    public IStatus getStatus() {
        return this.fLastStatus;
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.fOkButton != null && !this.fOkButton.isDisposed()) {
            this.fOkButton.setEnabled(!status.matches(4));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            if (this.fLastStatus.matches(4)) {
                StatusInfo status = new StatusInfo();
                status.setError("");
                this.fLastStatus = status;
            }
            this.updateStatus(this.fLastStatus);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData((Object)new GridData(768));
        this.fStatusLine.setErrorStatus(null);
        super.createButtonBar(composite);
        return composite;
    }

    public void setTitle(String title) {
        this.fTitle = title != null ? title : "";
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(this.fTitle);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setImage(this.fImage);
        }
    }
}

