/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.help.ui.internal.search;
import java.text.*;

import org.eclipse.help.ui.internal.ide.*;
import org.eclipse.jface.resource.*;
import org.eclipse.search.ui.text.*;
public class HelpSearchResult extends AbstractTextSearchResult {
	private static final ImageDescriptor IMAGE_DSCR_SEARCH = ImageDescriptor
			.createFromURL(HelpIdeResources
					.getImagePath(IHelpIdeConstants.IMAGE_FILE_SEARCH));
	private HelpSearchQuery query;
	public HelpSearchResult(HelpSearchQuery query) {
		super();
		this.query = query;
	}
	public String getLabel() {
		if (getMatchCount() == 1) {
			return query.getSingularLabel();
		} else
			return MessageFormat.format(query.getPluralLabelpattern(),
					new Object[]{new Integer(getMatchCount())});
	}
	public String getTooltip() {
		return getLabel();
	}
	public ImageDescriptor getImageDescriptor() {
		return IMAGE_DSCR_SEARCH;
	}
	public org.eclipse.search.ui.ISearchQuery getQuery() {
		return query;
	}
	public IEditorMatchAdapter getEditorMatchAdapter() {
		return null;
	}
	public IFileMatchAdapter getFileMatchAdapter() {
		return null;
	}
}