/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.util.StringTokenizer;
import snmp.SNMPBadValueException;
import snmp.SNMPOctetString;

public class SNMPNSAPAddress
extends SNMPOctetString {
    public SNMPNSAPAddress() {
        this.tag = (byte)69;
        this.data = new byte[6];
        for (int i = 0; i < 6; ++i) {
            this.data[i] = 0;
        }
    }

    public SNMPNSAPAddress(String string) throws SNMPBadValueException {
        this.tag = (byte)69;
        this.data = this.parseNSAPAddress(string);
    }

    public SNMPNSAPAddress(byte[] byArray) throws SNMPBadValueException {
        this.tag = (byte)69;
        if (byArray.length != 6) {
            throw new SNMPBadValueException(" NSAPAddress: bad BER encoding supplied to set value ");
        }
        this.data = byArray;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof byte[] && ((byte[])object).length == 6) {
            this.data = (byte[])object;
        } else if (object instanceof String) {
            this.data = this.parseNSAPAddress((String)object);
        } else {
            throw new SNMPBadValueException(" NSAPAddress: bad length byte string supplied to set value ");
        }
    }

    public String toString() {
        String string = new String();
        if (this.data.length > 0) {
            int n = this.data[0];
            if (n < 0) {
                n += 256;
            }
            string = string + Integer.toHexString(n);
            for (int i = 1; i < this.data.length; ++i) {
                n = this.data[i];
                if (n < 0) {
                    n += 256;
                }
                string = string + "-" + Integer.toHexString(n);
            }
        }
        return string;
    }

    private byte[] parseNSAPAddress(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .-");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            if (n != 6) {
                throw new SNMPBadValueException(" NSAPAddress: wrong number of components supplied to set value ");
            }
            byte[] byArray = new byte[n];
            stringTokenizer = new StringTokenizer(string, " .-");
            for (int i = 0; i < n; ++i) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                if (n2 < 0 || n2 > 255) {
                    throw new SNMPBadValueException(" NSAPAddress: invalid component supplied to set value ");
                }
                byArray[i] = (byte)n2;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" NSAPAddress: invalid component supplied to set value ");
        }
    }
}

