/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.math.BigInteger;
import java.util.Vector;
import snmp.SNMPBadValueException;
import snmp.SNMPIPAddress;
import snmp.SNMPInteger;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPSequence;
import snmp.SNMPTimeTicks;
import snmp.SNMPVarBindList;

public class SNMPTrapPDU
extends SNMPSequence {
    public SNMPTrapPDU(SNMPObjectIdentifier sNMPObjectIdentifier, SNMPIPAddress sNMPIPAddress, int n, int n2, SNMPTimeTicks sNMPTimeTicks, SNMPSequence sNMPSequence) throws SNMPBadValueException {
        this.tag = (byte)-92;
        Vector<SNMPObject> vector = new Vector<SNMPObject>();
        vector.addElement(sNMPObjectIdentifier);
        vector.addElement(sNMPIPAddress);
        vector.addElement(new SNMPInteger(n));
        vector.addElement(new SNMPInteger(n2));
        vector.addElement(sNMPTimeTicks);
        vector.addElement(sNMPSequence);
        this.setValue(vector);
    }

    public SNMPTrapPDU(SNMPObjectIdentifier sNMPObjectIdentifier, SNMPIPAddress sNMPIPAddress, int n, int n2, SNMPTimeTicks sNMPTimeTicks) throws SNMPBadValueException {
        this.tag = (byte)-92;
        Vector<SNMPObject> vector = new Vector<SNMPObject>();
        vector.addElement(sNMPObjectIdentifier);
        vector.addElement(sNMPIPAddress);
        vector.addElement(new SNMPInteger(n));
        vector.addElement(new SNMPInteger(n2));
        vector.addElement(sNMPTimeTicks);
        vector.addElement(new SNMPVarBindList());
        this.setValue(vector);
    }

    protected SNMPTrapPDU(byte[] byArray) throws SNMPBadValueException {
        this.tag = (byte)-92;
        this.extractFromBEREncoding(byArray);
    }

    public SNMPSequence getVarBindList() {
        Vector vector = (Vector)this.getValue();
        return (SNMPSequence)vector.elementAt(5);
    }

    public SNMPObjectIdentifier getEnterpriseOID() {
        Vector vector = (Vector)this.getValue();
        return (SNMPObjectIdentifier)vector.elementAt(0);
    }

    public SNMPIPAddress getAgentAddress() {
        Vector vector = (Vector)this.getValue();
        return (SNMPIPAddress)vector.elementAt(1);
    }

    public int getGenericTrap() {
        Vector vector = (Vector)this.getValue();
        return ((BigInteger)((SNMPInteger)vector.elementAt(2)).getValue()).intValue();
    }

    public int getSpecificTrap() {
        Vector vector = (Vector)this.getValue();
        return ((BigInteger)((SNMPInteger)vector.elementAt(3)).getValue()).intValue();
    }

    public long getTimestamp() {
        Vector vector = (Vector)this.getValue();
        return ((BigInteger)((SNMPTimeTicks)vector.elementAt(4)).getValue()).longValue();
    }
}

